/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessResponse;
import software.amazon.awssdk.services.route53recoveryreadiness.model.TagsCopier;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCellResponse
extends Route53RecoveryReadinessResponse
implements ToCopyableBuilder<Builder, UpdateCellResponse> {
    private static final SdkField<String> CELL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CellArn").getter(UpdateCellResponse.getter(UpdateCellResponse::cellArn)).setter(UpdateCellResponse.setter(Builder::cellArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cellArn").build()}).build();
    private static final SdkField<String> CELL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CellName").getter(UpdateCellResponse.getter(UpdateCellResponse::cellName)).setter(UpdateCellResponse.setter(Builder::cellName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cellName").build()}).build();
    private static final SdkField<List<String>> CELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cells").getter(UpdateCellResponse.getter(UpdateCellResponse::cells)).setter(UpdateCellResponse.setter(Builder::cells)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PARENT_READINESS_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParentReadinessScopes").getter(UpdateCellResponse.getter(UpdateCellResponse::parentReadinessScopes)).setter(UpdateCellResponse.setter(Builder::parentReadinessScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentReadinessScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateCellResponse.getter(UpdateCellResponse::tags)).setter(UpdateCellResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_ARN_FIELD, CELL_NAME_FIELD, CELLS_FIELD, PARENT_READINESS_SCOPES_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cellArn", CELL_ARN_FIELD);
            this.put("cellName", CELL_NAME_FIELD);
            this.put("cells", CELLS_FIELD);
            this.put("parentReadinessScopes", PARENT_READINESS_SCOPES_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String cellArn;
    private final String cellName;
    private final List<String> cells;
    private final List<String> parentReadinessScopes;
    private final Map<String, String> tags;

    private UpdateCellResponse(BuilderImpl builder) {
        super(builder);
        this.cellArn = builder.cellArn;
        this.cellName = builder.cellName;
        this.cells = builder.cells;
        this.parentReadinessScopes = builder.parentReadinessScopes;
        this.tags = builder.tags;
    }

    public final String cellArn() {
        return this.cellArn;
    }

    public final String cellName() {
        return this.cellName;
    }

    public final boolean hasCells() {
        return this.cells != null && !(this.cells instanceof SdkAutoConstructList);
    }

    public final List<String> cells() {
        return this.cells;
    }

    public final boolean hasParentReadinessScopes() {
        return this.parentReadinessScopes != null && !(this.parentReadinessScopes instanceof SdkAutoConstructList);
    }

    public final List<String> parentReadinessScopes() {
        return this.parentReadinessScopes;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cellArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cellName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCells() ? this.cells() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParentReadinessScopes() ? this.parentReadinessScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCellResponse)) {
            return false;
        }
        UpdateCellResponse other = (UpdateCellResponse)((Object)obj);
        return Objects.equals(this.cellArn(), other.cellArn()) && Objects.equals(this.cellName(), other.cellName()) && this.hasCells() == other.hasCells() && Objects.equals(this.cells(), other.cells()) && this.hasParentReadinessScopes() == other.hasParentReadinessScopes() && Objects.equals(this.parentReadinessScopes(), other.parentReadinessScopes()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCellResponse").add("CellArn", (Object)this.cellArn()).add("CellName", (Object)this.cellName()).add("Cells", this.hasCells() ? this.cells() : null).add("ParentReadinessScopes", this.hasParentReadinessScopes() ? this.parentReadinessScopes() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CellArn": {
                return Optional.ofNullable(clazz.cast(this.cellArn()));
            }
            case "CellName": {
                return Optional.ofNullable(clazz.cast(this.cellName()));
            }
            case "Cells": {
                return Optional.ofNullable(clazz.cast(this.cells()));
            }
            case "ParentReadinessScopes": {
                return Optional.ofNullable(clazz.cast(this.parentReadinessScopes()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCellResponse, T> g) {
        return obj -> g.apply((UpdateCellResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessResponse.BuilderImpl
    implements Builder {
        private String cellArn;
        private String cellName;
        private List<String> cells = DefaultSdkAutoConstructList.getInstance();
        private List<String> parentReadinessScopes = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCellResponse model) {
            super(model);
            this.cellArn(model.cellArn);
            this.cellName(model.cellName);
            this.cells(model.cells);
            this.parentReadinessScopes(model.parentReadinessScopes);
            this.tags(model.tags);
        }

        public final String getCellArn() {
            return this.cellArn;
        }

        public final void setCellArn(String cellArn) {
            this.cellArn = cellArn;
        }

        @Override
        public final Builder cellArn(String cellArn) {
            this.cellArn = cellArn;
            return this;
        }

        public final String getCellName() {
            return this.cellName;
        }

        public final void setCellName(String cellName) {
            this.cellName = cellName;
        }

        @Override
        public final Builder cellName(String cellName) {
            this.cellName = cellName;
            return this;
        }

        public final Collection<String> getCells() {
            if (this.cells instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cells;
        }

        public final void setCells(Collection<String> cells) {
            this.cells = ___listOf__stringCopier.copy(cells);
        }

        @Override
        public final Builder cells(Collection<String> cells) {
            this.cells = ___listOf__stringCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(String ... cells) {
            this.cells(Arrays.asList(cells));
            return this;
        }

        public final Collection<String> getParentReadinessScopes() {
            if (this.parentReadinessScopes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parentReadinessScopes;
        }

        public final void setParentReadinessScopes(Collection<String> parentReadinessScopes) {
            this.parentReadinessScopes = ___listOf__stringCopier.copy(parentReadinessScopes);
        }

        @Override
        public final Builder parentReadinessScopes(Collection<String> parentReadinessScopes) {
            this.parentReadinessScopes = ___listOf__stringCopier.copy(parentReadinessScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parentReadinessScopes(String ... parentReadinessScopes) {
            this.parentReadinessScopes(Arrays.asList(parentReadinessScopes));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public UpdateCellResponse build() {
            return new UpdateCellResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCellResponse> {
        public Builder cellArn(String var1);

        public Builder cellName(String var1);

        public Builder cells(Collection<String> var1);

        public Builder cells(String ... var1);

        public Builder parentReadinessScopes(Collection<String> var1);

        public Builder parentReadinessScopes(String ... var1);

        public Builder tags(Map<String, String> var1);
    }
}

