/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Route53RecoveryReadinessRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCellRequest
extends Route53RecoveryReadinessRequest
implements ToCopyableBuilder<Builder, UpdateCellRequest> {
    private static final SdkField<String> CELL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CellName").getter(UpdateCellRequest.getter(UpdateCellRequest::cellName)).setter(UpdateCellRequest.setter(Builder::cellName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("cellName").build()}).build();
    private static final SdkField<List<String>> CELLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Cells").getter(UpdateCellRequest.getter(UpdateCellRequest::cells)).setter(UpdateCellRequest.setter(Builder::cells)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cells").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CELL_NAME_FIELD, CELLS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("cellName", CELL_NAME_FIELD);
            this.put("cells", CELLS_FIELD);
        }
    });
    private final String cellName;
    private final List<String> cells;

    private UpdateCellRequest(BuilderImpl builder) {
        super(builder);
        this.cellName = builder.cellName;
        this.cells = builder.cells;
    }

    public final String cellName() {
        return this.cellName;
    }

    public final boolean hasCells() {
        return this.cells != null && !(this.cells instanceof SdkAutoConstructList);
    }

    public final List<String> cells() {
        return this.cells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cellName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCells() ? this.cells() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCellRequest)) {
            return false;
        }
        UpdateCellRequest other = (UpdateCellRequest)((Object)obj);
        return Objects.equals(this.cellName(), other.cellName()) && this.hasCells() == other.hasCells() && Objects.equals(this.cells(), other.cells());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCellRequest").add("CellName", (Object)this.cellName()).add("Cells", this.hasCells() ? this.cells() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CellName": {
                return Optional.ofNullable(clazz.cast(this.cellName()));
            }
            case "Cells": {
                return Optional.ofNullable(clazz.cast(this.cells()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCellRequest, T> g) {
        return obj -> g.apply((UpdateCellRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53RecoveryReadinessRequest.BuilderImpl
    implements Builder {
        private String cellName;
        private List<String> cells = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCellRequest model) {
            super(model);
            this.cellName(model.cellName);
            this.cells(model.cells);
        }

        public final String getCellName() {
            return this.cellName;
        }

        public final void setCellName(String cellName) {
            this.cellName = cellName;
        }

        @Override
        public final Builder cellName(String cellName) {
            this.cellName = cellName;
            return this;
        }

        public final Collection<String> getCells() {
            if (this.cells instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cells;
        }

        public final void setCells(Collection<String> cells) {
            this.cells = ___listOf__stringCopier.copy(cells);
        }

        @Override
        public final Builder cells(Collection<String> cells) {
            this.cells = ___listOf__stringCopier.copy(cells);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cells(String ... cells) {
            this.cells(Arrays.asList(cells));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCellRequest build() {
            return new UpdateCellRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53RecoveryReadinessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCellRequest> {
        public Builder cellName(String var1);

        public Builder cells(Collection<String> var1);

        public Builder cells(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

