/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53recoveryreadiness.model.Readiness;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceResult> {
    private static final SdkField<String> COMPONENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComponentId").getter(ResourceResult.getter(ResourceResult::componentId)).setter(ResourceResult.setter(Builder::componentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentId").build()}).build();
    private static final SdkField<Instant> LAST_CHECKED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastCheckedTimestamp").getter(ResourceResult.getter(ResourceResult::lastCheckedTimestamp)).setter(ResourceResult.setter(Builder::lastCheckedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastCheckedTimestamp").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> READINESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Readiness").getter(ResourceResult.getter(ResourceResult::readinessAsString)).setter(ResourceResult.setter(Builder::readiness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readiness").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(ResourceResult.getter(ResourceResult::resourceArn)).setter(ResourceResult.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_ID_FIELD, LAST_CHECKED_TIMESTAMP_FIELD, READINESS_FIELD, RESOURCE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("componentId", COMPONENT_ID_FIELD);
            this.put("lastCheckedTimestamp", LAST_CHECKED_TIMESTAMP_FIELD);
            this.put("readiness", READINESS_FIELD);
            this.put("resourceArn", RESOURCE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String componentId;
    private final Instant lastCheckedTimestamp;
    private final String readiness;
    private final String resourceArn;

    private ResourceResult(BuilderImpl builder) {
        this.componentId = builder.componentId;
        this.lastCheckedTimestamp = builder.lastCheckedTimestamp;
        this.readiness = builder.readiness;
        this.resourceArn = builder.resourceArn;
    }

    public final String componentId() {
        return this.componentId;
    }

    public final Instant lastCheckedTimestamp() {
        return this.lastCheckedTimestamp;
    }

    public final Readiness readiness() {
        return Readiness.fromValue(this.readiness);
    }

    public final String readinessAsString() {
        return this.readiness;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.componentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastCheckedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.readinessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceResult)) {
            return false;
        }
        ResourceResult other = (ResourceResult)obj;
        return Objects.equals(this.componentId(), other.componentId()) && Objects.equals(this.lastCheckedTimestamp(), other.lastCheckedTimestamp()) && Objects.equals(this.readinessAsString(), other.readinessAsString()) && Objects.equals(this.resourceArn(), other.resourceArn());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceResult").add("ComponentId", (Object)this.componentId()).add("LastCheckedTimestamp", (Object)this.lastCheckedTimestamp()).add("Readiness", (Object)this.readinessAsString()).add("ResourceArn", (Object)this.resourceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComponentId": {
                return Optional.ofNullable(clazz.cast(this.componentId()));
            }
            case "LastCheckedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastCheckedTimestamp()));
            }
            case "Readiness": {
                return Optional.ofNullable(clazz.cast(this.readinessAsString()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceResult, T> g) {
        return obj -> g.apply((ResourceResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String componentId;
        private Instant lastCheckedTimestamp;
        private String readiness;
        private String resourceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceResult model) {
            this.componentId(model.componentId);
            this.lastCheckedTimestamp(model.lastCheckedTimestamp);
            this.readiness(model.readiness);
            this.resourceArn(model.resourceArn);
        }

        public final String getComponentId() {
            return this.componentId;
        }

        public final void setComponentId(String componentId) {
            this.componentId = componentId;
        }

        @Override
        public final Builder componentId(String componentId) {
            this.componentId = componentId;
            return this;
        }

        public final Instant getLastCheckedTimestamp() {
            return this.lastCheckedTimestamp;
        }

        public final void setLastCheckedTimestamp(Instant lastCheckedTimestamp) {
            this.lastCheckedTimestamp = lastCheckedTimestamp;
        }

        @Override
        public final Builder lastCheckedTimestamp(Instant lastCheckedTimestamp) {
            this.lastCheckedTimestamp = lastCheckedTimestamp;
            return this;
        }

        public final String getReadiness() {
            return this.readiness;
        }

        public final void setReadiness(String readiness) {
            this.readiness = readiness;
        }

        @Override
        public final Builder readiness(String readiness) {
            this.readiness = readiness;
            return this;
        }

        @Override
        public final Builder readiness(Readiness readiness) {
            this.readiness(readiness == null ? null : readiness.toString());
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public ResourceResult build() {
            return new ResourceResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceResult> {
        public Builder componentId(String var1);

        public Builder lastCheckedTimestamp(Instant var1);

        public Builder readiness(String var1);

        public Builder readiness(Readiness var1);

        public Builder resourceArn(String var1);
    }
}

