/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.CollectionSummariesCopier;
import software.amazon.awssdk.services.route53.model.CollectionSummary;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCidrCollectionsResponse
extends Route53Response
implements ToCopyableBuilder<Builder, ListCidrCollectionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCidrCollectionsResponse.getter(ListCidrCollectionsResponse::nextToken)).setter(ListCidrCollectionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("NextToken").build()}).build();
    private static final SdkField<List<CollectionSummary>> CIDR_COLLECTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrCollections").getter(ListCidrCollectionsResponse.getter(ListCidrCollectionsResponse::cidrCollections)).setter(ListCidrCollectionsResponse.setter(Builder::cidrCollections)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrCollections").unmarshallLocationName("CidrCollections").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CollectionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CIDR_COLLECTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("CidrCollections", CIDR_COLLECTIONS_FIELD);
        }
    });
    private final String nextToken;
    private final List<CollectionSummary> cidrCollections;

    private ListCidrCollectionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.cidrCollections = builder.cidrCollections;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCidrCollections() {
        return this.cidrCollections != null && !(this.cidrCollections instanceof SdkAutoConstructList);
    }

    public final List<CollectionSummary> cidrCollections() {
        return this.cidrCollections;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrCollections() ? this.cidrCollections() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCidrCollectionsResponse)) {
            return false;
        }
        ListCidrCollectionsResponse other = (ListCidrCollectionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCidrCollections() == other.hasCidrCollections() && Objects.equals(this.cidrCollections(), other.cidrCollections());
    }

    public final String toString() {
        return ToString.builder((String)"ListCidrCollectionsResponse").add("NextToken", (Object)this.nextToken()).add("CidrCollections", this.hasCidrCollections() ? this.cidrCollections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "CidrCollections": {
                return Optional.ofNullable(clazz.cast(this.cidrCollections()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCidrCollectionsResponse, T> g) {
        return obj -> g.apply((ListCidrCollectionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CollectionSummary> cidrCollections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCidrCollectionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.cidrCollections(model.cidrCollections);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CollectionSummary.Builder> getCidrCollections() {
            List<CollectionSummary.Builder> result = CollectionSummariesCopier.copyToBuilder(this.cidrCollections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCidrCollections(Collection<CollectionSummary.BuilderImpl> cidrCollections) {
            this.cidrCollections = CollectionSummariesCopier.copyFromBuilder(cidrCollections);
        }

        @Override
        public final Builder cidrCollections(Collection<CollectionSummary> cidrCollections) {
            this.cidrCollections = CollectionSummariesCopier.copy(cidrCollections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrCollections(CollectionSummary ... cidrCollections) {
            this.cidrCollections(Arrays.asList(cidrCollections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrCollections(Consumer<CollectionSummary.Builder> ... cidrCollections) {
            this.cidrCollections(Stream.of(cidrCollections).map(c -> (CollectionSummary)((CollectionSummary.Builder)CollectionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCidrCollectionsResponse build() {
            return new ListCidrCollectionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCidrCollectionsResponse> {
        public Builder nextToken(String var1);

        public Builder cidrCollections(Collection<CollectionSummary> var1);

        public Builder cidrCollections(CollectionSummary ... var1);

        public Builder cidrCollections(Consumer<CollectionSummary.Builder> ... var1);
    }
}

