/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.ReusableDelegationSetLimit;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReusableDelegationSetLimitResponse
extends Route53Response
implements ToCopyableBuilder<Builder, GetReusableDelegationSetLimitResponse> {
    private static final SdkField<ReusableDelegationSetLimit> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Limit").getter(GetReusableDelegationSetLimitResponse.getter(GetReusableDelegationSetLimitResponse::limit)).setter(GetReusableDelegationSetLimitResponse.setter(Builder::limit)).constructor(ReusableDelegationSetLimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").unmarshallLocationName("Limit").build()}).build();
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Count").getter(GetReusableDelegationSetLimitResponse.getter(GetReusableDelegationSetLimitResponse::count)).setter(GetReusableDelegationSetLimitResponse.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").unmarshallLocationName("Count").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Limit", LIMIT_FIELD);
            this.put("Count", COUNT_FIELD);
        }
    });
    private final ReusableDelegationSetLimit limit;
    private final Long count;

    private GetReusableDelegationSetLimitResponse(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.count = builder.count;
    }

    public final ReusableDelegationSetLimit limit() {
        return this.limit;
    }

    public final Long count() {
        return this.count;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReusableDelegationSetLimitResponse)) {
            return false;
        }
        GetReusableDelegationSetLimitResponse other = (GetReusableDelegationSetLimitResponse)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.count(), other.count());
    }

    public final String toString() {
        return ToString.builder((String)"GetReusableDelegationSetLimitResponse").add("Limit", (Object)this.limit()).add("Count", (Object)this.count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetReusableDelegationSetLimitResponse, T> g) {
        return obj -> g.apply((GetReusableDelegationSetLimitResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private ReusableDelegationSetLimit limit;
        private Long count;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReusableDelegationSetLimitResponse model) {
            super(model);
            this.limit(model.limit);
            this.count(model.count);
        }

        public final ReusableDelegationSetLimit.Builder getLimit() {
            return this.limit != null ? this.limit.toBuilder() : null;
        }

        public final void setLimit(ReusableDelegationSetLimit.BuilderImpl limit) {
            this.limit = limit != null ? limit.build() : null;
        }

        @Override
        public final Builder limit(ReusableDelegationSetLimit limit) {
            this.limit = limit;
            return this;
        }

        public final Long getCount() {
            return this.count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        @Override
        public GetReusableDelegationSetLimitResponse build() {
            return new GetReusableDelegationSetLimitResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReusableDelegationSetLimitResponse> {
        public Builder limit(ReusableDelegationSetLimit var1);

        default public Builder limit(Consumer<ReusableDelegationSetLimit.Builder> limit) {
            return this.limit((ReusableDelegationSetLimit)((ReusableDelegationSetLimit.Builder)ReusableDelegationSetLimit.builder().applyMutation(limit)).build());
        }

        public Builder count(Long var1);
    }
}

