/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.robomaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.robomaker.model.WorldGenerationJobErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorldFailure
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorldFailure> {
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(WorldFailure.getter(WorldFailure::failureCodeAsString)).setter(WorldFailure.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> SAMPLE_FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleFailureReason").getter(WorldFailure.getter(WorldFailure::sampleFailureReason)).setter(WorldFailure.setter(Builder::sampleFailureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleFailureReason").build()}).build();
    private static final SdkField<Integer> FAILURE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("failureCount").getter(WorldFailure.getter(WorldFailure::failureCount)).setter(WorldFailure.setter(Builder::failureCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_CODE_FIELD, SAMPLE_FAILURE_REASON_FIELD, FAILURE_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("failureCode", FAILURE_CODE_FIELD);
            this.put("sampleFailureReason", SAMPLE_FAILURE_REASON_FIELD);
            this.put("failureCount", FAILURE_COUNT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String failureCode;
    private final String sampleFailureReason;
    private final Integer failureCount;

    private WorldFailure(BuilderImpl builder) {
        this.failureCode = builder.failureCode;
        this.sampleFailureReason = builder.sampleFailureReason;
        this.failureCount = builder.failureCount;
    }

    public final WorldGenerationJobErrorCode failureCode() {
        return WorldGenerationJobErrorCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public final String sampleFailureReason() {
        return this.sampleFailureReason;
    }

    public final Integer failureCount() {
        return this.failureCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleFailureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorldFailure)) {
            return false;
        }
        WorldFailure other = (WorldFailure)obj;
        return Objects.equals(this.failureCodeAsString(), other.failureCodeAsString()) && Objects.equals(this.sampleFailureReason(), other.sampleFailureReason()) && Objects.equals(this.failureCount(), other.failureCount());
    }

    public final String toString() {
        return ToString.builder((String)"WorldFailure").add("FailureCode", (Object)this.failureCodeAsString()).add("SampleFailureReason", (Object)this.sampleFailureReason()).add("FailureCount", (Object)this.failureCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
            case "sampleFailureReason": {
                return Optional.ofNullable(clazz.cast(this.sampleFailureReason()));
            }
            case "failureCount": {
                return Optional.ofNullable(clazz.cast(this.failureCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<WorldFailure, T> g) {
        return obj -> g.apply((WorldFailure)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureCode;
        private String sampleFailureReason;
        private Integer failureCount;

        private BuilderImpl() {
        }

        private BuilderImpl(WorldFailure model) {
            this.failureCode(model.failureCode);
            this.sampleFailureReason(model.sampleFailureReason);
            this.failureCount(model.failureCount);
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(WorldGenerationJobErrorCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public final String getSampleFailureReason() {
            return this.sampleFailureReason;
        }

        public final void setSampleFailureReason(String sampleFailureReason) {
            this.sampleFailureReason = sampleFailureReason;
        }

        @Override
        public final Builder sampleFailureReason(String sampleFailureReason) {
            this.sampleFailureReason = sampleFailureReason;
            return this;
        }

        public final Integer getFailureCount() {
            return this.failureCount;
        }

        public final void setFailureCount(Integer failureCount) {
            this.failureCount = failureCount;
        }

        @Override
        public final Builder failureCount(Integer failureCount) {
            this.failureCount = failureCount;
            return this;
        }

        public WorldFailure build() {
            return new WorldFailure(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorldFailure> {
        public Builder failureCode(String var1);

        public Builder failureCode(WorldGenerationJobErrorCode var1);

        public Builder sampleFailureReason(String var1);

        public Builder failureCount(Integer var1);
    }
}

