/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resourceexplorer2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.resourceexplorer2.ResourceExplorer2Client;
import software.amazon.awssdk.services.resourceexplorer2.internal.UserAgentUtils;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersRequest;
import software.amazon.awssdk.services.resourceexplorer2.model.ListIndexesForMembersResponse;
import software.amazon.awssdk.services.resourceexplorer2.model.MemberIndex;

public class ListIndexesForMembersIterable
implements SdkIterable<ListIndexesForMembersResponse> {
    private final ResourceExplorer2Client client;
    private final ListIndexesForMembersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListIndexesForMembersIterable(ResourceExplorer2Client client, ListIndexesForMembersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListIndexesForMembersResponseFetcher();
    }

    public Iterator<ListIndexesForMembersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MemberIndex> indexes() {
        Function<ListIndexesForMembersResponse, Iterator> getIterator = response -> {
            if (response != null && response.indexes() != null) {
                return response.indexes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListIndexesForMembersResponseFetcher
    implements SyncPageFetcher<ListIndexesForMembersResponse> {
        private ListIndexesForMembersResponseFetcher() {
        }

        public boolean hasNextPage(ListIndexesForMembersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListIndexesForMembersResponse nextPage(ListIndexesForMembersResponse previousPage) {
            if (previousPage == null) {
                return ListIndexesForMembersIterable.this.client.listIndexesForMembers(ListIndexesForMembersIterable.this.firstRequest);
            }
            return ListIndexesForMembersIterable.this.client.listIndexesForMembers((ListIndexesForMembersRequest)((Object)ListIndexesForMembersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

