/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionResiliencyScoreCopier;
import software.amazon.awssdk.services.resiliencehub.model.DisruptionType;
import software.amazon.awssdk.services.resiliencehub.model.ResiliencyScoreType;
import software.amazon.awssdk.services.resiliencehub.model.ScoringComponentResiliencyScore;
import software.amazon.awssdk.services.resiliencehub.model.ScoringComponentResiliencyScoresCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResiliencyScore
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResiliencyScore> {
    private static final SdkField<Map<String, ScoringComponentResiliencyScore>> COMPONENT_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("componentScore").getter(ResiliencyScore.getter(ResiliencyScore::componentScoreAsStrings)).setter(ResiliencyScore.setter(Builder::componentScoreWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentScore").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScoringComponentResiliencyScore::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Double>> DISRUPTION_SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("disruptionScore").getter(ResiliencyScore.getter(ResiliencyScore::disruptionScoreAsStrings)).setter(ResiliencyScore.setter(Builder::disruptionScoreWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disruptionScore").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Double> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("score").getter(ResiliencyScore.getter(ResiliencyScore::score)).setter(ResiliencyScore.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPONENT_SCORE_FIELD, DISRUPTION_SCORE_FIELD, SCORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("componentScore", COMPONENT_SCORE_FIELD);
            this.put("disruptionScore", DISRUPTION_SCORE_FIELD);
            this.put("score", SCORE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, ScoringComponentResiliencyScore> componentScore;
    private final Map<String, Double> disruptionScore;
    private final Double score;

    private ResiliencyScore(BuilderImpl builder) {
        this.componentScore = builder.componentScore;
        this.disruptionScore = builder.disruptionScore;
        this.score = builder.score;
    }

    public final Map<ResiliencyScoreType, ScoringComponentResiliencyScore> componentScore() {
        return ScoringComponentResiliencyScoresCopier.copyStringToEnum(this.componentScore);
    }

    public final boolean hasComponentScore() {
        return this.componentScore != null && !(this.componentScore instanceof SdkAutoConstructMap);
    }

    public final Map<String, ScoringComponentResiliencyScore> componentScoreAsStrings() {
        return this.componentScore;
    }

    public final Map<DisruptionType, Double> disruptionScore() {
        return DisruptionResiliencyScoreCopier.copyStringToEnum(this.disruptionScore);
    }

    public final boolean hasDisruptionScore() {
        return this.disruptionScore != null && !(this.disruptionScore instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> disruptionScoreAsStrings() {
        return this.disruptionScore;
    }

    public final Double score() {
        return this.score;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentScore() ? this.componentScoreAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisruptionScore() ? this.disruptionScoreAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResiliencyScore)) {
            return false;
        }
        ResiliencyScore other = (ResiliencyScore)obj;
        return this.hasComponentScore() == other.hasComponentScore() && Objects.equals(this.componentScoreAsStrings(), other.componentScoreAsStrings()) && this.hasDisruptionScore() == other.hasDisruptionScore() && Objects.equals(this.disruptionScoreAsStrings(), other.disruptionScoreAsStrings()) && Objects.equals(this.score(), other.score());
    }

    public final String toString() {
        return ToString.builder((String)"ResiliencyScore").add("ComponentScore", this.hasComponentScore() ? this.componentScoreAsStrings() : null).add("DisruptionScore", this.hasDisruptionScore() ? this.disruptionScoreAsStrings() : null).add("Score", (Object)this.score()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "componentScore": {
                return Optional.ofNullable(clazz.cast(this.componentScoreAsStrings()));
            }
            case "disruptionScore": {
                return Optional.ofNullable(clazz.cast(this.disruptionScoreAsStrings()));
            }
            case "score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResiliencyScore, T> g) {
        return obj -> g.apply((ResiliencyScore)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, ScoringComponentResiliencyScore> componentScore = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, Double> disruptionScore = DefaultSdkAutoConstructMap.getInstance();
        private Double score;

        private BuilderImpl() {
        }

        private BuilderImpl(ResiliencyScore model) {
            this.componentScoreWithStrings(model.componentScore);
            this.disruptionScoreWithStrings(model.disruptionScore);
            this.score(model.score);
        }

        public final Map<String, ScoringComponentResiliencyScore.Builder> getComponentScore() {
            Map<String, ScoringComponentResiliencyScore.Builder> result = ScoringComponentResiliencyScoresCopier.copyToBuilder(this.componentScore);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponentScore(Map<String, ScoringComponentResiliencyScore.BuilderImpl> componentScore) {
            this.componentScore = ScoringComponentResiliencyScoresCopier.copyFromBuilder(componentScore);
        }

        @Override
        public final Builder componentScoreWithStrings(Map<String, ScoringComponentResiliencyScore> componentScore) {
            this.componentScore = ScoringComponentResiliencyScoresCopier.copy(componentScore);
            return this;
        }

        @Override
        public final Builder componentScore(Map<ResiliencyScoreType, ScoringComponentResiliencyScore> componentScore) {
            this.componentScore = ScoringComponentResiliencyScoresCopier.copyEnumToString(componentScore);
            return this;
        }

        public final Map<String, Double> getDisruptionScore() {
            if (this.disruptionScore instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.disruptionScore;
        }

        public final void setDisruptionScore(Map<String, Double> disruptionScore) {
            this.disruptionScore = DisruptionResiliencyScoreCopier.copy(disruptionScore);
        }

        @Override
        public final Builder disruptionScoreWithStrings(Map<String, Double> disruptionScore) {
            this.disruptionScore = DisruptionResiliencyScoreCopier.copy(disruptionScore);
            return this;
        }

        @Override
        public final Builder disruptionScore(Map<DisruptionType, Double> disruptionScore) {
            this.disruptionScore = DisruptionResiliencyScoreCopier.copyEnumToString(disruptionScore);
            return this;
        }

        public final Double getScore() {
            return this.score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public ResiliencyScore build() {
            return new ResiliencyScore(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResiliencyScore> {
        public Builder componentScoreWithStrings(Map<String, ScoringComponentResiliencyScore> var1);

        public Builder componentScore(Map<ResiliencyScoreType, ScoringComponentResiliencyScore> var1);

        public Builder disruptionScoreWithStrings(Map<String, Double> var1);

        public Builder disruptionScore(Map<DisruptionType, Double> var1);

        public Builder score(Double var1);
    }
}

