/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.resiliencehub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogicalResourceId
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogicalResourceId> {
    private static final SdkField<String> EKS_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eksSourceName").getter(LogicalResourceId.getter(LogicalResourceId::eksSourceName)).setter(LogicalResourceId.setter(Builder::eksSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksSourceName").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(LogicalResourceId.getter(LogicalResourceId::identifier)).setter(LogicalResourceId.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> LOGICAL_STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logicalStackName").getter(LogicalResourceId.getter(LogicalResourceId::logicalStackName)).setter(LogicalResourceId.setter(Builder::logicalStackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicalStackName").build()}).build();
    private static final SdkField<String> RESOURCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceGroupName").getter(LogicalResourceId.getter(LogicalResourceId::resourceGroupName)).setter(LogicalResourceId.setter(Builder::resourceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGroupName").build()}).build();
    private static final SdkField<String> TERRAFORM_SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("terraformSourceName").getter(LogicalResourceId.getter(LogicalResourceId::terraformSourceName)).setter(LogicalResourceId.setter(Builder::terraformSourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terraformSourceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_SOURCE_NAME_FIELD, IDENTIFIER_FIELD, LOGICAL_STACK_NAME_FIELD, RESOURCE_GROUP_NAME_FIELD, TERRAFORM_SOURCE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eksSourceName", EKS_SOURCE_NAME_FIELD);
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("logicalStackName", LOGICAL_STACK_NAME_FIELD);
            this.put("resourceGroupName", RESOURCE_GROUP_NAME_FIELD);
            this.put("terraformSourceName", TERRAFORM_SOURCE_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String eksSourceName;
    private final String identifier;
    private final String logicalStackName;
    private final String resourceGroupName;
    private final String terraformSourceName;

    private LogicalResourceId(BuilderImpl builder) {
        this.eksSourceName = builder.eksSourceName;
        this.identifier = builder.identifier;
        this.logicalStackName = builder.logicalStackName;
        this.resourceGroupName = builder.resourceGroupName;
        this.terraformSourceName = builder.terraformSourceName;
    }

    public final String eksSourceName() {
        return this.eksSourceName;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String logicalStackName() {
        return this.logicalStackName;
    }

    public final String resourceGroupName() {
        return this.resourceGroupName;
    }

    public final String terraformSourceName() {
        return this.terraformSourceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eksSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalStackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.terraformSourceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicalResourceId)) {
            return false;
        }
        LogicalResourceId other = (LogicalResourceId)obj;
        return Objects.equals(this.eksSourceName(), other.eksSourceName()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.logicalStackName(), other.logicalStackName()) && Objects.equals(this.resourceGroupName(), other.resourceGroupName()) && Objects.equals(this.terraformSourceName(), other.terraformSourceName());
    }

    public final String toString() {
        return ToString.builder((String)"LogicalResourceId").add("EksSourceName", (Object)this.eksSourceName()).add("Identifier", (Object)this.identifier()).add("LogicalStackName", (Object)this.logicalStackName()).add("ResourceGroupName", (Object)this.resourceGroupName()).add("TerraformSourceName", (Object)this.terraformSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eksSourceName": {
                return Optional.ofNullable(clazz.cast(this.eksSourceName()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "logicalStackName": {
                return Optional.ofNullable(clazz.cast(this.logicalStackName()));
            }
            case "resourceGroupName": {
                return Optional.ofNullable(clazz.cast(this.resourceGroupName()));
            }
            case "terraformSourceName": {
                return Optional.ofNullable(clazz.cast(this.terraformSourceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LogicalResourceId, T> g) {
        return obj -> g.apply((LogicalResourceId)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eksSourceName;
        private String identifier;
        private String logicalStackName;
        private String resourceGroupName;
        private String terraformSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(LogicalResourceId model) {
            this.eksSourceName(model.eksSourceName);
            this.identifier(model.identifier);
            this.logicalStackName(model.logicalStackName);
            this.resourceGroupName(model.resourceGroupName);
            this.terraformSourceName(model.terraformSourceName);
        }

        public final String getEksSourceName() {
            return this.eksSourceName;
        }

        public final void setEksSourceName(String eksSourceName) {
            this.eksSourceName = eksSourceName;
        }

        @Override
        public final Builder eksSourceName(String eksSourceName) {
            this.eksSourceName = eksSourceName;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getLogicalStackName() {
            return this.logicalStackName;
        }

        public final void setLogicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
        }

        @Override
        public final Builder logicalStackName(String logicalStackName) {
            this.logicalStackName = logicalStackName;
            return this;
        }

        public final String getResourceGroupName() {
            return this.resourceGroupName;
        }

        public final void setResourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
        }

        @Override
        public final Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        public final String getTerraformSourceName() {
            return this.terraformSourceName;
        }

        public final void setTerraformSourceName(String terraformSourceName) {
            this.terraformSourceName = terraformSourceName;
        }

        @Override
        public final Builder terraformSourceName(String terraformSourceName) {
            this.terraformSourceName = terraformSourceName;
            return this;
        }

        public LogicalResourceId build() {
            return new LogicalResourceId(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogicalResourceId> {
        public Builder eksSourceName(String var1);

        public Builder identifier(String var1);

        public Builder logicalStackName(String var1);

        public Builder resourceGroupName(String var1);

        public Builder terraformSourceName(String var1);
    }
}

