/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.waiters;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.rekognition.RekognitionAsyncClient;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsRequest;
import software.amazon.awssdk.services.rekognition.model.DescribeProjectVersionsResponse;
import software.amazon.awssdk.services.rekognition.waiters.DefaultRekognitionAsyncWaiter;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkPublicApi
@ThreadSafe
@Immutable
public interface RekognitionAsyncWaiter
extends SdkAutoCloseable {
    default public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionRunning(DescribeProjectVersionsRequest describeProjectVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionRunning(Consumer<DescribeProjectVersionsRequest.Builder> describeProjectVersionsRequest) {
        return this.waitUntilProjectVersionRunning((DescribeProjectVersionsRequest)((Object)((DescribeProjectVersionsRequest.Builder)DescribeProjectVersionsRequest.builder().applyMutation(describeProjectVersionsRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionRunning(DescribeProjectVersionsRequest describeProjectVersionsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionRunning(Consumer<DescribeProjectVersionsRequest.Builder> describeProjectVersionsRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilProjectVersionRunning((DescribeProjectVersionsRequest)((Object)((DescribeProjectVersionsRequest.Builder)DescribeProjectVersionsRequest.builder().applyMutation(describeProjectVersionsRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    default public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionTrainingCompleted(DescribeProjectVersionsRequest describeProjectVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionTrainingCompleted(Consumer<DescribeProjectVersionsRequest.Builder> describeProjectVersionsRequest) {
        return this.waitUntilProjectVersionTrainingCompleted((DescribeProjectVersionsRequest)((Object)((DescribeProjectVersionsRequest.Builder)DescribeProjectVersionsRequest.builder().applyMutation(describeProjectVersionsRequest)).build()));
    }

    default public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionTrainingCompleted(DescribeProjectVersionsRequest describeProjectVersionsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<WaiterResponse<DescribeProjectVersionsResponse>> waitUntilProjectVersionTrainingCompleted(Consumer<DescribeProjectVersionsRequest.Builder> describeProjectVersionsRequest, Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return this.waitUntilProjectVersionTrainingCompleted((DescribeProjectVersionsRequest)((Object)((DescribeProjectVersionsRequest.Builder)DescribeProjectVersionsRequest.builder().applyMutation(describeProjectVersionsRequest)).build()), ((WaiterOverrideConfiguration.Builder)WaiterOverrideConfiguration.builder().applyMutation(overrideConfig)).build());
    }

    public static Builder builder() {
        return DefaultRekognitionAsyncWaiter.builder();
    }

    public static RekognitionAsyncWaiter create() {
        return DefaultRekognitionAsyncWaiter.builder().build();
    }

    public static interface Builder {
        public Builder scheduledExecutorService(ScheduledExecutorService var1);

        public Builder overrideConfiguration(WaiterOverrideConfiguration var1);

        default public Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return this.overrideConfiguration(builder.build());
        }

        public Builder client(RekognitionAsyncClient var1);

        public RekognitionAsyncWaiter build();
    }
}

