/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rekognition.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rekognition.model.VideoColorRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VideoMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VideoMetadata> {
    private static final SdkField<String> CODEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Codec").getter(VideoMetadata.getter(VideoMetadata::codec)).setter(VideoMetadata.setter(Builder::codec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Codec").build()}).build();
    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DurationMillis").getter(VideoMetadata.getter(VideoMetadata::durationMillis)).setter(VideoMetadata.setter(Builder::durationMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Format").getter(VideoMetadata.getter(VideoMetadata::format)).setter(VideoMetadata.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()}).build();
    private static final SdkField<Float> FRAME_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("FrameRate").getter(VideoMetadata.getter(VideoMetadata::frameRate)).setter(VideoMetadata.setter(Builder::frameRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameRate").build()}).build();
    private static final SdkField<Long> FRAME_HEIGHT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FrameHeight").getter(VideoMetadata.getter(VideoMetadata::frameHeight)).setter(VideoMetadata.setter(Builder::frameHeight)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameHeight").build()}).build();
    private static final SdkField<Long> FRAME_WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FrameWidth").getter(VideoMetadata.getter(VideoMetadata::frameWidth)).setter(VideoMetadata.setter(Builder::frameWidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameWidth").build()}).build();
    private static final SdkField<String> COLOR_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColorRange").getter(VideoMetadata.getter(VideoMetadata::colorRangeAsString)).setter(VideoMetadata.setter(Builder::colorRange)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColorRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODEC_FIELD, DURATION_MILLIS_FIELD, FORMAT_FIELD, FRAME_RATE_FIELD, FRAME_HEIGHT_FIELD, FRAME_WIDTH_FIELD, COLOR_RANGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Codec", CODEC_FIELD);
            this.put("DurationMillis", DURATION_MILLIS_FIELD);
            this.put("Format", FORMAT_FIELD);
            this.put("FrameRate", FRAME_RATE_FIELD);
            this.put("FrameHeight", FRAME_HEIGHT_FIELD);
            this.put("FrameWidth", FRAME_WIDTH_FIELD);
            this.put("ColorRange", COLOR_RANGE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String codec;
    private final Long durationMillis;
    private final String format;
    private final Float frameRate;
    private final Long frameHeight;
    private final Long frameWidth;
    private final String colorRange;

    private VideoMetadata(BuilderImpl builder) {
        this.codec = builder.codec;
        this.durationMillis = builder.durationMillis;
        this.format = builder.format;
        this.frameRate = builder.frameRate;
        this.frameHeight = builder.frameHeight;
        this.frameWidth = builder.frameWidth;
        this.colorRange = builder.colorRange;
    }

    public final String codec() {
        return this.codec;
    }

    public final Long durationMillis() {
        return this.durationMillis;
    }

    public final String format() {
        return this.format;
    }

    public final Float frameRate() {
        return this.frameRate;
    }

    public final Long frameHeight() {
        return this.frameHeight;
    }

    public final Long frameWidth() {
        return this.frameWidth;
    }

    public final VideoColorRange colorRange() {
        return VideoColorRange.fromValue(this.colorRange);
    }

    public final String colorRangeAsString() {
        return this.colorRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.codec());
        hashCode = 31 * hashCode + Objects.hashCode(this.durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameHeight());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameWidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.colorRangeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoMetadata)) {
            return false;
        }
        VideoMetadata other = (VideoMetadata)obj;
        return Objects.equals(this.codec(), other.codec()) && Objects.equals(this.durationMillis(), other.durationMillis()) && Objects.equals(this.format(), other.format()) && Objects.equals(this.frameRate(), other.frameRate()) && Objects.equals(this.frameHeight(), other.frameHeight()) && Objects.equals(this.frameWidth(), other.frameWidth()) && Objects.equals(this.colorRangeAsString(), other.colorRangeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"VideoMetadata").add("Codec", (Object)this.codec()).add("DurationMillis", (Object)this.durationMillis()).add("Format", (Object)this.format()).add("FrameRate", (Object)this.frameRate()).add("FrameHeight", (Object)this.frameHeight()).add("FrameWidth", (Object)this.frameWidth()).add("ColorRange", (Object)this.colorRangeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Codec": {
                return Optional.ofNullable(clazz.cast(this.codec()));
            }
            case "DurationMillis": {
                return Optional.ofNullable(clazz.cast(this.durationMillis()));
            }
            case "Format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "FrameRate": {
                return Optional.ofNullable(clazz.cast(this.frameRate()));
            }
            case "FrameHeight": {
                return Optional.ofNullable(clazz.cast(this.frameHeight()));
            }
            case "FrameWidth": {
                return Optional.ofNullable(clazz.cast(this.frameWidth()));
            }
            case "ColorRange": {
                return Optional.ofNullable(clazz.cast(this.colorRangeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VideoMetadata, T> g) {
        return obj -> g.apply((VideoMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String codec;
        private Long durationMillis;
        private String format;
        private Float frameRate;
        private Long frameHeight;
        private Long frameWidth;
        private String colorRange;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoMetadata model) {
            this.codec(model.codec);
            this.durationMillis(model.durationMillis);
            this.format(model.format);
            this.frameRate(model.frameRate);
            this.frameHeight(model.frameHeight);
            this.frameWidth(model.frameWidth);
            this.colorRange(model.colorRange);
        }

        public final String getCodec() {
            return this.codec;
        }

        public final void setCodec(String codec) {
            this.codec = codec;
        }

        @Override
        public final Builder codec(String codec) {
            this.codec = codec;
            return this;
        }

        public final Long getDurationMillis() {
            return this.durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final Float getFrameRate() {
            return this.frameRate;
        }

        public final void setFrameRate(Float frameRate) {
            this.frameRate = frameRate;
        }

        @Override
        public final Builder frameRate(Float frameRate) {
            this.frameRate = frameRate;
            return this;
        }

        public final Long getFrameHeight() {
            return this.frameHeight;
        }

        public final void setFrameHeight(Long frameHeight) {
            this.frameHeight = frameHeight;
        }

        @Override
        public final Builder frameHeight(Long frameHeight) {
            this.frameHeight = frameHeight;
            return this;
        }

        public final Long getFrameWidth() {
            return this.frameWidth;
        }

        public final void setFrameWidth(Long frameWidth) {
            this.frameWidth = frameWidth;
        }

        @Override
        public final Builder frameWidth(Long frameWidth) {
            this.frameWidth = frameWidth;
            return this;
        }

        public final String getColorRange() {
            return this.colorRange;
        }

        public final void setColorRange(String colorRange) {
            this.colorRange = colorRange;
        }

        @Override
        public final Builder colorRange(String colorRange) {
            this.colorRange = colorRange;
            return this;
        }

        @Override
        public final Builder colorRange(VideoColorRange colorRange) {
            this.colorRange(colorRange == null ? null : colorRange.toString());
            return this;
        }

        public VideoMetadata build() {
            return new VideoMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VideoMetadata> {
        public Builder codec(String var1);

        public Builder durationMillis(Long var1);

        public Builder format(String var1);

        public Builder frameRate(Float var1);

        public Builder frameHeight(Long var1);

        public Builder frameWidth(Long var1);

        public Builder colorRange(String var1);

        public Builder colorRange(VideoColorRange var1);
    }
}

