/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.FailoverState;
import software.amazon.awssdk.services.rds.model.GlobalClusterMember;
import software.amazon.awssdk.services.rds.model.GlobalClusterMemberListCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlobalCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlobalCluster> {
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalClusterIdentifier").getter(GlobalCluster.getter(GlobalCluster::globalClusterIdentifier)).setter(GlobalCluster.setter(Builder::globalClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build()}).build();
    private static final SdkField<String> GLOBAL_CLUSTER_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalClusterResourceId").getter(GlobalCluster.getter(GlobalCluster::globalClusterResourceId)).setter(GlobalCluster.setter(Builder::globalClusterResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterResourceId").build()}).build();
    private static final SdkField<String> GLOBAL_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalClusterArn").getter(GlobalCluster.getter(GlobalCluster::globalClusterArn)).setter(GlobalCluster.setter(Builder::globalClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(GlobalCluster.getter(GlobalCluster::status)).setter(GlobalCluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(GlobalCluster.getter(GlobalCluster::engine)).setter(GlobalCluster.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(GlobalCluster.getter(GlobalCluster::engineVersion)).setter(GlobalCluster.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> ENGINE_LIFECYCLE_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineLifecycleSupport").getter(GlobalCluster.getter(GlobalCluster::engineLifecycleSupport)).setter(GlobalCluster.setter(Builder::engineLifecycleSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineLifecycleSupport").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(GlobalCluster.getter(GlobalCluster::databaseName)).setter(GlobalCluster.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(GlobalCluster.getter(GlobalCluster::storageEncrypted)).setter(GlobalCluster.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(GlobalCluster.getter(GlobalCluster::deletionProtection)).setter(GlobalCluster.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<List<GlobalClusterMember>> GLOBAL_CLUSTER_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GlobalClusterMembers").getter(GlobalCluster.getter(GlobalCluster::globalClusterMembers)).setter(GlobalCluster.setter(Builder::globalClusterMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterMembers").build(), ListTrait.builder().memberLocationName("GlobalClusterMember").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GlobalClusterMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterMember").build()}).build()).build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(GlobalCluster.getter(GlobalCluster::endpoint)).setter(GlobalCluster.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<FailoverState> FAILOVER_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailoverState").getter(GlobalCluster.getter(GlobalCluster::failoverState)).setter(GlobalCluster.setter(Builder::failoverState)).constructor(FailoverState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailoverState").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(GlobalCluster.getter(GlobalCluster::tagList)).setter(GlobalCluster.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_CLUSTER_IDENTIFIER_FIELD, GLOBAL_CLUSTER_RESOURCE_ID_FIELD, GLOBAL_CLUSTER_ARN_FIELD, STATUS_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, ENGINE_LIFECYCLE_SUPPORT_FIELD, DATABASE_NAME_FIELD, STORAGE_ENCRYPTED_FIELD, DELETION_PROTECTION_FIELD, GLOBAL_CLUSTER_MEMBERS_FIELD, ENDPOINT_FIELD, FAILOVER_STATE_FIELD, TAG_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String globalClusterIdentifier;
    private final String globalClusterResourceId;
    private final String globalClusterArn;
    private final String status;
    private final String engine;
    private final String engineVersion;
    private final String engineLifecycleSupport;
    private final String databaseName;
    private final Boolean storageEncrypted;
    private final Boolean deletionProtection;
    private final List<GlobalClusterMember> globalClusterMembers;
    private final String endpoint;
    private final FailoverState failoverState;
    private final List<Tag> tagList;

    private GlobalCluster(BuilderImpl builder) {
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.globalClusterResourceId = builder.globalClusterResourceId;
        this.globalClusterArn = builder.globalClusterArn;
        this.status = builder.status;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.engineLifecycleSupport = builder.engineLifecycleSupport;
        this.databaseName = builder.databaseName;
        this.storageEncrypted = builder.storageEncrypted;
        this.deletionProtection = builder.deletionProtection;
        this.globalClusterMembers = builder.globalClusterMembers;
        this.endpoint = builder.endpoint;
        this.failoverState = builder.failoverState;
        this.tagList = builder.tagList;
    }

    public final String globalClusterIdentifier() {
        return this.globalClusterIdentifier;
    }

    public final String globalClusterResourceId() {
        return this.globalClusterResourceId;
    }

    public final String globalClusterArn() {
        return this.globalClusterArn;
    }

    public final String status() {
        return this.status;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String engineLifecycleSupport() {
        return this.engineLifecycleSupport;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final boolean hasGlobalClusterMembers() {
        return this.globalClusterMembers != null && !(this.globalClusterMembers instanceof SdkAutoConstructList);
    }

    public final List<GlobalClusterMember> globalClusterMembers() {
        return this.globalClusterMembers;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final FailoverState failoverState() {
        return this.failoverState;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalClusterResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineLifecycleSupport());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalClusterMembers() ? this.globalClusterMembers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.failoverState());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlobalCluster)) {
            return false;
        }
        GlobalCluster other = (GlobalCluster)obj;
        return Objects.equals(this.globalClusterIdentifier(), other.globalClusterIdentifier()) && Objects.equals(this.globalClusterResourceId(), other.globalClusterResourceId()) && Objects.equals(this.globalClusterArn(), other.globalClusterArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.engineLifecycleSupport(), other.engineLifecycleSupport()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && this.hasGlobalClusterMembers() == other.hasGlobalClusterMembers() && Objects.equals(this.globalClusterMembers(), other.globalClusterMembers()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.failoverState(), other.failoverState()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList());
    }

    public final String toString() {
        return ToString.builder((String)"GlobalCluster").add("GlobalClusterIdentifier", (Object)this.globalClusterIdentifier()).add("GlobalClusterResourceId", (Object)this.globalClusterResourceId()).add("GlobalClusterArn", (Object)this.globalClusterArn()).add("Status", (Object)this.status()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("EngineLifecycleSupport", (Object)this.engineLifecycleSupport()).add("DatabaseName", (Object)this.databaseName()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("DeletionProtection", (Object)this.deletionProtection()).add("GlobalClusterMembers", this.hasGlobalClusterMembers() ? this.globalClusterMembers() : null).add("Endpoint", (Object)this.endpoint()).add("FailoverState", (Object)this.failoverState()).add("TagList", this.hasTagList() ? this.tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GlobalClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.globalClusterIdentifier()));
            }
            case "GlobalClusterResourceId": {
                return Optional.ofNullable(clazz.cast(this.globalClusterResourceId()));
            }
            case "GlobalClusterArn": {
                return Optional.ofNullable(clazz.cast(this.globalClusterArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "EngineLifecycleSupport": {
                return Optional.ofNullable(clazz.cast(this.engineLifecycleSupport()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "GlobalClusterMembers": {
                return Optional.ofNullable(clazz.cast(this.globalClusterMembers()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "FailoverState": {
                return Optional.ofNullable(clazz.cast(this.failoverState()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GlobalCluster, T> g) {
        return obj -> g.apply((GlobalCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String globalClusterIdentifier;
        private String globalClusterResourceId;
        private String globalClusterArn;
        private String status;
        private String engine;
        private String engineVersion;
        private String engineLifecycleSupport;
        private String databaseName;
        private Boolean storageEncrypted;
        private Boolean deletionProtection;
        private List<GlobalClusterMember> globalClusterMembers = DefaultSdkAutoConstructList.getInstance();
        private String endpoint;
        private FailoverState failoverState;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlobalCluster model) {
            this.globalClusterIdentifier(model.globalClusterIdentifier);
            this.globalClusterResourceId(model.globalClusterResourceId);
            this.globalClusterArn(model.globalClusterArn);
            this.status(model.status);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.engineLifecycleSupport(model.engineLifecycleSupport);
            this.databaseName(model.databaseName);
            this.storageEncrypted(model.storageEncrypted);
            this.deletionProtection(model.deletionProtection);
            this.globalClusterMembers(model.globalClusterMembers);
            this.endpoint(model.endpoint);
            this.failoverState(model.failoverState);
            this.tagList(model.tagList);
        }

        public final String getGlobalClusterIdentifier() {
            return this.globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final String getGlobalClusterResourceId() {
            return this.globalClusterResourceId;
        }

        public final void setGlobalClusterResourceId(String globalClusterResourceId) {
            this.globalClusterResourceId = globalClusterResourceId;
        }

        @Override
        public final Builder globalClusterResourceId(String globalClusterResourceId) {
            this.globalClusterResourceId = globalClusterResourceId;
            return this;
        }

        public final String getGlobalClusterArn() {
            return this.globalClusterArn;
        }

        public final void setGlobalClusterArn(String globalClusterArn) {
            this.globalClusterArn = globalClusterArn;
        }

        @Override
        public final Builder globalClusterArn(String globalClusterArn) {
            this.globalClusterArn = globalClusterArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEngineLifecycleSupport() {
            return this.engineLifecycleSupport;
        }

        public final void setEngineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
        }

        @Override
        public final Builder engineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final List<GlobalClusterMember.Builder> getGlobalClusterMembers() {
            List<GlobalClusterMember.Builder> result = GlobalClusterMemberListCopier.copyToBuilder(this.globalClusterMembers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlobalClusterMembers(Collection<GlobalClusterMember.BuilderImpl> globalClusterMembers) {
            this.globalClusterMembers = GlobalClusterMemberListCopier.copyFromBuilder(globalClusterMembers);
        }

        @Override
        public final Builder globalClusterMembers(Collection<GlobalClusterMember> globalClusterMembers) {
            this.globalClusterMembers = GlobalClusterMemberListCopier.copy(globalClusterMembers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalClusterMembers(GlobalClusterMember ... globalClusterMembers) {
            this.globalClusterMembers(Arrays.asList(globalClusterMembers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalClusterMembers(Consumer<GlobalClusterMember.Builder> ... globalClusterMembers) {
            this.globalClusterMembers(Stream.of(globalClusterMembers).map(c -> (GlobalClusterMember)((GlobalClusterMember.Builder)GlobalClusterMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final FailoverState.Builder getFailoverState() {
            return this.failoverState != null ? this.failoverState.toBuilder() : null;
        }

        public final void setFailoverState(FailoverState.BuilderImpl failoverState) {
            this.failoverState = failoverState != null ? failoverState.build() : null;
        }

        @Override
        public final Builder failoverState(FailoverState failoverState) {
            this.failoverState = failoverState;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GlobalCluster build() {
            return new GlobalCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlobalCluster> {
        public Builder globalClusterIdentifier(String var1);

        public Builder globalClusterResourceId(String var1);

        public Builder globalClusterArn(String var1);

        public Builder status(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder engineLifecycleSupport(String var1);

        public Builder databaseName(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder deletionProtection(Boolean var1);

        public Builder globalClusterMembers(Collection<GlobalClusterMember> var1);

        public Builder globalClusterMembers(GlobalClusterMember ... var1);

        public Builder globalClusterMembers(Consumer<GlobalClusterMember.Builder> ... var1);

        public Builder endpoint(String var1);

        public Builder failoverState(FailoverState var1);

        default public Builder failoverState(Consumer<FailoverState.Builder> failoverState) {
            return this.failoverState((FailoverState)((FailoverState.Builder)FailoverState.builder().applyMutation(failoverState)).build());
        }

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);
    }
}

