/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.internal.UserAgentUtils;
import software.amazon.awssdk.services.quicksight.model.CustomPermissions;
import software.amazon.awssdk.services.quicksight.model.ListCustomPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListCustomPermissionsResponse;

public class ListCustomPermissionsPublisher
implements SdkPublisher<ListCustomPermissionsResponse> {
    private final QuickSightAsyncClient client;
    private final ListCustomPermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomPermissionsPublisher(QuickSightAsyncClient client, ListCustomPermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomPermissionsPublisher(QuickSightAsyncClient client, ListCustomPermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomPermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomPermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomPermissions> customPermissionsList() {
        Function<ListCustomPermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.customPermissionsList() != null) {
                return response.customPermissionsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomPermissionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomPermissionsResponseFetcher
    implements AsyncPageFetcher<ListCustomPermissionsResponse> {
        private ListCustomPermissionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomPermissionsResponse> nextPage(ListCustomPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomPermissionsPublisher.this.client.listCustomPermissions(ListCustomPermissionsPublisher.this.firstRequest);
            }
            return ListCustomPermissionsPublisher.this.client.listCustomPermissions((ListCustomPermissionsRequest)((Object)ListCustomPermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

