/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VisualRole {
    PRIMARY("PRIMARY"),
    COMPLIMENTARY("COMPLIMENTARY"),
    MULTI_INTENT("MULTI_INTENT"),
    FALLBACK("FALLBACK"),
    FRAGMENT("FRAGMENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VisualRole> VALUE_MAP;
    private final String value;

    private VisualRole(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VisualRole fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VisualRole> knownValues() {
        EnumSet<VisualRole> knownValues = EnumSet.allOf(VisualRole.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VisualRole.class, VisualRole::toString);
    }
}

