/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DimensionField;
import software.amazon.awssdk.services.quicksight.model.MeasureField;
import software.amazon.awssdk.services.quicksight.model.TopBottomComputationType;
import software.amazon.awssdk.services.quicksight.model.TopBottomSortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TopBottomMoversComputation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TopBottomMoversComputation> {
    private static final SdkField<String> COMPUTATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputationId").getter(TopBottomMoversComputation.getter(TopBottomMoversComputation::computationId)).setter(TopBottomMoversComputation.setter(Builder::computationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TopBottomMoversComputation.getter(TopBottomMoversComputation::name)).setter(TopBottomMoversComputation.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<DimensionField> TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Time").getter(TopBottomMoversComputation.getter(TopBottomMoversComputation::time)).setter(TopBottomMoversComputation.setter(Builder::time)).constructor(DimensionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()}).build();
    private static final SdkField<DimensionField> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Category").getter(TopBottomMoversComputation.getter(TopBottomMoversComputation::category)).setter(TopBottomMoversComputation.setter(Builder::category)).constructor(DimensionField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<MeasureField> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Value").getter(TopBottomMoversComputation.getter(TopBottomMoversComputation::value)).setter(TopBottomMoversComputation.setter(Builder::value)).constructor(MeasureField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Integer> MOVER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MoverSize").getter(TopBottomMoversComputation.getter(TopBottomMoversComputation::moverSize)).setter(TopBottomMoversComputation.setter(Builder::moverSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MoverSize").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(TopBottomMoversComputation.getter(TopBottomMoversComputation::sortOrderAsString)).setter(TopBottomMoversComputation.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TopBottomMoversComputation.getter(TopBottomMoversComputation::typeAsString)).setter(TopBottomMoversComputation.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_ID_FIELD, NAME_FIELD, TIME_FIELD, CATEGORY_FIELD, VALUE_FIELD, MOVER_SIZE_FIELD, SORT_ORDER_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ComputationId", COMPUTATION_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Time", TIME_FIELD);
            this.put("Category", CATEGORY_FIELD);
            this.put("Value", VALUE_FIELD);
            this.put("MoverSize", MOVER_SIZE_FIELD);
            this.put("SortOrder", SORT_ORDER_FIELD);
            this.put("Type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String computationId;
    private final String name;
    private final DimensionField time;
    private final DimensionField category;
    private final MeasureField value;
    private final Integer moverSize;
    private final String sortOrder;
    private final String type;

    private TopBottomMoversComputation(BuilderImpl builder) {
        this.computationId = builder.computationId;
        this.name = builder.name;
        this.time = builder.time;
        this.category = builder.category;
        this.value = builder.value;
        this.moverSize = builder.moverSize;
        this.sortOrder = builder.sortOrder;
        this.type = builder.type;
    }

    public final String computationId() {
        return this.computationId;
    }

    public final String name() {
        return this.name;
    }

    public final DimensionField time() {
        return this.time;
    }

    public final DimensionField category() {
        return this.category;
    }

    public final MeasureField value() {
        return this.value;
    }

    public final Integer moverSize() {
        return this.moverSize;
    }

    public final TopBottomSortOrder sortOrder() {
        return TopBottomSortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final TopBottomComputationType type() {
        return TopBottomComputationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.moverSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopBottomMoversComputation)) {
            return false;
        }
        TopBottomMoversComputation other = (TopBottomMoversComputation)obj;
        return Objects.equals(this.computationId(), other.computationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.time(), other.time()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.moverSize(), other.moverSize()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TopBottomMoversComputation").add("ComputationId", (Object)this.computationId()).add("Name", (Object)this.name()).add("Time", (Object)this.time()).add("Category", (Object)this.category()).add("Value", (Object)this.value()).add("MoverSize", (Object)this.moverSize()).add("SortOrder", (Object)this.sortOrderAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ComputationId": {
                return Optional.ofNullable(clazz.cast(this.computationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "MoverSize": {
                return Optional.ofNullable(clazz.cast(this.moverSize()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TopBottomMoversComputation, T> g) {
        return obj -> g.apply((TopBottomMoversComputation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String computationId;
        private String name;
        private DimensionField time;
        private DimensionField category;
        private MeasureField value;
        private Integer moverSize;
        private String sortOrder;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(TopBottomMoversComputation model) {
            this.computationId(model.computationId);
            this.name(model.name);
            this.time(model.time);
            this.category(model.category);
            this.value(model.value);
            this.moverSize(model.moverSize);
            this.sortOrder(model.sortOrder);
            this.type(model.type);
        }

        public final String getComputationId() {
            return this.computationId;
        }

        public final void setComputationId(String computationId) {
            this.computationId = computationId;
        }

        @Override
        public final Builder computationId(String computationId) {
            this.computationId = computationId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DimensionField.Builder getTime() {
            return this.time != null ? this.time.toBuilder() : null;
        }

        public final void setTime(DimensionField.BuilderImpl time) {
            this.time = time != null ? time.build() : null;
        }

        @Override
        public final Builder time(DimensionField time) {
            this.time = time;
            return this;
        }

        public final DimensionField.Builder getCategory() {
            return this.category != null ? this.category.toBuilder() : null;
        }

        public final void setCategory(DimensionField.BuilderImpl category) {
            this.category = category != null ? category.build() : null;
        }

        @Override
        public final Builder category(DimensionField category) {
            this.category = category;
            return this;
        }

        public final MeasureField.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        public final void setValue(MeasureField.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MeasureField value) {
            this.value = value;
            return this;
        }

        public final Integer getMoverSize() {
            return this.moverSize;
        }

        public final void setMoverSize(Integer moverSize) {
            this.moverSize = moverSize;
        }

        @Override
        public final Builder moverSize(Integer moverSize) {
            this.moverSize = moverSize;
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(TopBottomSortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(TopBottomComputationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public TopBottomMoversComputation build() {
            return new TopBottomMoversComputation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TopBottomMoversComputation> {
        public Builder computationId(String var1);

        public Builder name(String var1);

        public Builder time(DimensionField var1);

        default public Builder time(Consumer<DimensionField.Builder> time) {
            return this.time((DimensionField)((DimensionField.Builder)DimensionField.builder().applyMutation(time)).build());
        }

        public Builder category(DimensionField var1);

        default public Builder category(Consumer<DimensionField.Builder> category) {
            return this.category((DimensionField)((DimensionField.Builder)DimensionField.builder().applyMutation(category)).build());
        }

        public Builder value(MeasureField var1);

        default public Builder value(Consumer<MeasureField.Builder> value) {
            return this.value((MeasureField)((MeasureField.Builder)MeasureField.builder().applyMutation(value)).build());
        }

        public Builder moverSize(Integer var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(TopBottomSortOrder var1);

        public Builder type(String var1);

        public Builder type(TopBottomComputationType var1);
    }
}

