/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TextQualifier {
    DOUBLE_QUOTE("DOUBLE_QUOTE"),
    SINGLE_QUOTE("SINGLE_QUOTE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TextQualifier> VALUE_MAP;
    private final String value;

    private TextQualifier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TextQualifier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TextQualifier> knownValues() {
        EnumSet<TextQualifier> knownValues = EnumSet.allOf(TextQualifier.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TextQualifier.class, TextQualifier::toString);
    }
}

