/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TableFieldImageConfiguration;
import software.amazon.awssdk.services.quicksight.model.TableFieldLinkConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableFieldURLConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableFieldURLConfiguration> {
    private static final SdkField<TableFieldLinkConfiguration> LINK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LinkConfiguration").getter(TableFieldURLConfiguration.getter(TableFieldURLConfiguration::linkConfiguration)).setter(TableFieldURLConfiguration.setter(Builder::linkConfiguration)).constructor(TableFieldLinkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkConfiguration").build()}).build();
    private static final SdkField<TableFieldImageConfiguration> IMAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageConfiguration").getter(TableFieldURLConfiguration.getter(TableFieldURLConfiguration::imageConfiguration)).setter(TableFieldURLConfiguration.setter(Builder::imageConfiguration)).constructor(TableFieldImageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINK_CONFIGURATION_FIELD, IMAGE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LinkConfiguration", LINK_CONFIGURATION_FIELD);
            this.put("ImageConfiguration", IMAGE_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final TableFieldLinkConfiguration linkConfiguration;
    private final TableFieldImageConfiguration imageConfiguration;

    private TableFieldURLConfiguration(BuilderImpl builder) {
        this.linkConfiguration = builder.linkConfiguration;
        this.imageConfiguration = builder.imageConfiguration;
    }

    public final TableFieldLinkConfiguration linkConfiguration() {
        return this.linkConfiguration;
    }

    public final TableFieldImageConfiguration imageConfiguration() {
        return this.imageConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.linkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldURLConfiguration)) {
            return false;
        }
        TableFieldURLConfiguration other = (TableFieldURLConfiguration)obj;
        return Objects.equals(this.linkConfiguration(), other.linkConfiguration()) && Objects.equals(this.imageConfiguration(), other.imageConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"TableFieldURLConfiguration").add("LinkConfiguration", (Object)this.linkConfiguration()).add("ImageConfiguration", (Object)this.imageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LinkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.linkConfiguration()));
            }
            case "ImageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TableFieldURLConfiguration, T> g) {
        return obj -> g.apply((TableFieldURLConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TableFieldLinkConfiguration linkConfiguration;
        private TableFieldImageConfiguration imageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldURLConfiguration model) {
            this.linkConfiguration(model.linkConfiguration);
            this.imageConfiguration(model.imageConfiguration);
        }

        public final TableFieldLinkConfiguration.Builder getLinkConfiguration() {
            return this.linkConfiguration != null ? this.linkConfiguration.toBuilder() : null;
        }

        public final void setLinkConfiguration(TableFieldLinkConfiguration.BuilderImpl linkConfiguration) {
            this.linkConfiguration = linkConfiguration != null ? linkConfiguration.build() : null;
        }

        @Override
        public final Builder linkConfiguration(TableFieldLinkConfiguration linkConfiguration) {
            this.linkConfiguration = linkConfiguration;
            return this;
        }

        public final TableFieldImageConfiguration.Builder getImageConfiguration() {
            return this.imageConfiguration != null ? this.imageConfiguration.toBuilder() : null;
        }

        public final void setImageConfiguration(TableFieldImageConfiguration.BuilderImpl imageConfiguration) {
            this.imageConfiguration = imageConfiguration != null ? imageConfiguration.build() : null;
        }

        @Override
        public final Builder imageConfiguration(TableFieldImageConfiguration imageConfiguration) {
            this.imageConfiguration = imageConfiguration;
            return this;
        }

        public TableFieldURLConfiguration build() {
            return new TableFieldURLConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableFieldURLConfiguration> {
        public Builder linkConfiguration(TableFieldLinkConfiguration var1);

        default public Builder linkConfiguration(Consumer<TableFieldLinkConfiguration.Builder> linkConfiguration) {
            return this.linkConfiguration((TableFieldLinkConfiguration)((TableFieldLinkConfiguration.Builder)TableFieldLinkConfiguration.builder().applyMutation(linkConfiguration)).build());
        }

        public Builder imageConfiguration(TableFieldImageConfiguration var1);

        default public Builder imageConfiguration(Consumer<TableFieldImageConfiguration.Builder> imageConfiguration) {
            return this.imageConfiguration((TableFieldImageConfiguration)((TableFieldImageConfiguration.Builder)TableFieldImageConfiguration.builder().applyMutation(imageConfiguration)).build());
        }
    }
}

