/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.PivotTotalOptions;
import software.amazon.awssdk.services.quicksight.model.SubtotalOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PivotTableTotalOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PivotTableTotalOptions> {
    private static final SdkField<SubtotalOptions> ROW_SUBTOTAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowSubtotalOptions").getter(PivotTableTotalOptions.getter(PivotTableTotalOptions::rowSubtotalOptions)).setter(PivotTableTotalOptions.setter(Builder::rowSubtotalOptions)).constructor(SubtotalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowSubtotalOptions").build()}).build();
    private static final SdkField<SubtotalOptions> COLUMN_SUBTOTAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColumnSubtotalOptions").getter(PivotTableTotalOptions.getter(PivotTableTotalOptions::columnSubtotalOptions)).setter(PivotTableTotalOptions.setter(Builder::columnSubtotalOptions)).constructor(SubtotalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnSubtotalOptions").build()}).build();
    private static final SdkField<PivotTotalOptions> ROW_TOTAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowTotalOptions").getter(PivotTableTotalOptions.getter(PivotTableTotalOptions::rowTotalOptions)).setter(PivotTableTotalOptions.setter(Builder::rowTotalOptions)).constructor(PivotTotalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowTotalOptions").build()}).build();
    private static final SdkField<PivotTotalOptions> COLUMN_TOTAL_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ColumnTotalOptions").getter(PivotTableTotalOptions.getter(PivotTableTotalOptions::columnTotalOptions)).setter(PivotTableTotalOptions.setter(Builder::columnTotalOptions)).constructor(PivotTotalOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnTotalOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROW_SUBTOTAL_OPTIONS_FIELD, COLUMN_SUBTOTAL_OPTIONS_FIELD, ROW_TOTAL_OPTIONS_FIELD, COLUMN_TOTAL_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RowSubtotalOptions", ROW_SUBTOTAL_OPTIONS_FIELD);
            this.put("ColumnSubtotalOptions", COLUMN_SUBTOTAL_OPTIONS_FIELD);
            this.put("RowTotalOptions", ROW_TOTAL_OPTIONS_FIELD);
            this.put("ColumnTotalOptions", COLUMN_TOTAL_OPTIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SubtotalOptions rowSubtotalOptions;
    private final SubtotalOptions columnSubtotalOptions;
    private final PivotTotalOptions rowTotalOptions;
    private final PivotTotalOptions columnTotalOptions;

    private PivotTableTotalOptions(BuilderImpl builder) {
        this.rowSubtotalOptions = builder.rowSubtotalOptions;
        this.columnSubtotalOptions = builder.columnSubtotalOptions;
        this.rowTotalOptions = builder.rowTotalOptions;
        this.columnTotalOptions = builder.columnTotalOptions;
    }

    public final SubtotalOptions rowSubtotalOptions() {
        return this.rowSubtotalOptions;
    }

    public final SubtotalOptions columnSubtotalOptions() {
        return this.columnSubtotalOptions;
    }

    public final PivotTotalOptions rowTotalOptions() {
        return this.rowTotalOptions;
    }

    public final PivotTotalOptions columnTotalOptions() {
        return this.columnTotalOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.rowSubtotalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnSubtotalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowTotalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnTotalOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableTotalOptions)) {
            return false;
        }
        PivotTableTotalOptions other = (PivotTableTotalOptions)obj;
        return Objects.equals(this.rowSubtotalOptions(), other.rowSubtotalOptions()) && Objects.equals(this.columnSubtotalOptions(), other.columnSubtotalOptions()) && Objects.equals(this.rowTotalOptions(), other.rowTotalOptions()) && Objects.equals(this.columnTotalOptions(), other.columnTotalOptions());
    }

    public final String toString() {
        return ToString.builder((String)"PivotTableTotalOptions").add("RowSubtotalOptions", (Object)this.rowSubtotalOptions()).add("ColumnSubtotalOptions", (Object)this.columnSubtotalOptions()).add("RowTotalOptions", (Object)this.rowTotalOptions()).add("ColumnTotalOptions", (Object)this.columnTotalOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RowSubtotalOptions": {
                return Optional.ofNullable(clazz.cast(this.rowSubtotalOptions()));
            }
            case "ColumnSubtotalOptions": {
                return Optional.ofNullable(clazz.cast(this.columnSubtotalOptions()));
            }
            case "RowTotalOptions": {
                return Optional.ofNullable(clazz.cast(this.rowTotalOptions()));
            }
            case "ColumnTotalOptions": {
                return Optional.ofNullable(clazz.cast(this.columnTotalOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PivotTableTotalOptions, T> g) {
        return obj -> g.apply((PivotTableTotalOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SubtotalOptions rowSubtotalOptions;
        private SubtotalOptions columnSubtotalOptions;
        private PivotTotalOptions rowTotalOptions;
        private PivotTotalOptions columnTotalOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableTotalOptions model) {
            this.rowSubtotalOptions(model.rowSubtotalOptions);
            this.columnSubtotalOptions(model.columnSubtotalOptions);
            this.rowTotalOptions(model.rowTotalOptions);
            this.columnTotalOptions(model.columnTotalOptions);
        }

        public final SubtotalOptions.Builder getRowSubtotalOptions() {
            return this.rowSubtotalOptions != null ? this.rowSubtotalOptions.toBuilder() : null;
        }

        public final void setRowSubtotalOptions(SubtotalOptions.BuilderImpl rowSubtotalOptions) {
            this.rowSubtotalOptions = rowSubtotalOptions != null ? rowSubtotalOptions.build() : null;
        }

        @Override
        public final Builder rowSubtotalOptions(SubtotalOptions rowSubtotalOptions) {
            this.rowSubtotalOptions = rowSubtotalOptions;
            return this;
        }

        public final SubtotalOptions.Builder getColumnSubtotalOptions() {
            return this.columnSubtotalOptions != null ? this.columnSubtotalOptions.toBuilder() : null;
        }

        public final void setColumnSubtotalOptions(SubtotalOptions.BuilderImpl columnSubtotalOptions) {
            this.columnSubtotalOptions = columnSubtotalOptions != null ? columnSubtotalOptions.build() : null;
        }

        @Override
        public final Builder columnSubtotalOptions(SubtotalOptions columnSubtotalOptions) {
            this.columnSubtotalOptions = columnSubtotalOptions;
            return this;
        }

        public final PivotTotalOptions.Builder getRowTotalOptions() {
            return this.rowTotalOptions != null ? this.rowTotalOptions.toBuilder() : null;
        }

        public final void setRowTotalOptions(PivotTotalOptions.BuilderImpl rowTotalOptions) {
            this.rowTotalOptions = rowTotalOptions != null ? rowTotalOptions.build() : null;
        }

        @Override
        public final Builder rowTotalOptions(PivotTotalOptions rowTotalOptions) {
            this.rowTotalOptions = rowTotalOptions;
            return this;
        }

        public final PivotTotalOptions.Builder getColumnTotalOptions() {
            return this.columnTotalOptions != null ? this.columnTotalOptions.toBuilder() : null;
        }

        public final void setColumnTotalOptions(PivotTotalOptions.BuilderImpl columnTotalOptions) {
            this.columnTotalOptions = columnTotalOptions != null ? columnTotalOptions.build() : null;
        }

        @Override
        public final Builder columnTotalOptions(PivotTotalOptions columnTotalOptions) {
            this.columnTotalOptions = columnTotalOptions;
            return this;
        }

        public PivotTableTotalOptions build() {
            return new PivotTableTotalOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PivotTableTotalOptions> {
        public Builder rowSubtotalOptions(SubtotalOptions var1);

        default public Builder rowSubtotalOptions(Consumer<SubtotalOptions.Builder> rowSubtotalOptions) {
            return this.rowSubtotalOptions((SubtotalOptions)((SubtotalOptions.Builder)SubtotalOptions.builder().applyMutation(rowSubtotalOptions)).build());
        }

        public Builder columnSubtotalOptions(SubtotalOptions var1);

        default public Builder columnSubtotalOptions(Consumer<SubtotalOptions.Builder> columnSubtotalOptions) {
            return this.columnSubtotalOptions((SubtotalOptions)((SubtotalOptions.Builder)SubtotalOptions.builder().applyMutation(columnSubtotalOptions)).build());
        }

        public Builder rowTotalOptions(PivotTotalOptions var1);

        default public Builder rowTotalOptions(Consumer<PivotTotalOptions.Builder> rowTotalOptions) {
            return this.rowTotalOptions((PivotTotalOptions)((PivotTotalOptions.Builder)PivotTotalOptions.builder().applyMutation(rowTotalOptions)).build());
        }

        public Builder columnTotalOptions(PivotTotalOptions var1);

        default public Builder columnTotalOptions(Consumer<PivotTotalOptions.Builder> columnTotalOptions) {
            return this.columnTotalOptions((PivotTotalOptions)((PivotTotalOptions.Builder)PivotTotalOptions.builder().applyMutation(columnTotalOptions)).build());
        }
    }
}

