/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataPathValue;
import software.amazon.awssdk.services.quicksight.model.DataPathValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PivotTableDataPathOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PivotTableDataPathOption> {
    private static final SdkField<List<DataPathValue>> DATA_PATH_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataPathList").getter(PivotTableDataPathOption.getter(PivotTableDataPathOption::dataPathList)).setter(PivotTableDataPathOption.setter(Builder::dataPathList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPathList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataPathValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Width").getter(PivotTableDataPathOption.getter(PivotTableDataPathOption::width)).setter(PivotTableDataPathOption.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PATH_LIST_FIELD, WIDTH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DataPathList", DATA_PATH_LIST_FIELD);
            this.put("Width", WIDTH_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<DataPathValue> dataPathList;
    private final String width;

    private PivotTableDataPathOption(BuilderImpl builder) {
        this.dataPathList = builder.dataPathList;
        this.width = builder.width;
    }

    public final boolean hasDataPathList() {
        return this.dataPathList != null && !(this.dataPathList instanceof SdkAutoConstructList);
    }

    public final List<DataPathValue> dataPathList() {
        return this.dataPathList;
    }

    public final String width() {
        return this.width;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataPathList() ? this.dataPathList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableDataPathOption)) {
            return false;
        }
        PivotTableDataPathOption other = (PivotTableDataPathOption)obj;
        return this.hasDataPathList() == other.hasDataPathList() && Objects.equals(this.dataPathList(), other.dataPathList()) && Objects.equals(this.width(), other.width());
    }

    public final String toString() {
        return ToString.builder((String)"PivotTableDataPathOption").add("DataPathList", this.hasDataPathList() ? this.dataPathList() : null).add("Width", (Object)this.width()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataPathList": {
                return Optional.ofNullable(clazz.cast(this.dataPathList()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PivotTableDataPathOption, T> g) {
        return obj -> g.apply((PivotTableDataPathOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataPathValue> dataPathList = DefaultSdkAutoConstructList.getInstance();
        private String width;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableDataPathOption model) {
            this.dataPathList(model.dataPathList);
            this.width(model.width);
        }

        public final List<DataPathValue.Builder> getDataPathList() {
            List<DataPathValue.Builder> result = DataPathValueListCopier.copyToBuilder(this.dataPathList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataPathList(Collection<DataPathValue.BuilderImpl> dataPathList) {
            this.dataPathList = DataPathValueListCopier.copyFromBuilder(dataPathList);
        }

        @Override
        public final Builder dataPathList(Collection<DataPathValue> dataPathList) {
            this.dataPathList = DataPathValueListCopier.copy(dataPathList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPathList(DataPathValue ... dataPathList) {
            this.dataPathList(Arrays.asList(dataPathList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPathList(Consumer<DataPathValue.Builder> ... dataPathList) {
            this.dataPathList(Stream.of(dataPathList).map(c -> (DataPathValue)((DataPathValue.Builder)DataPathValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWidth() {
            return this.width;
        }

        public final void setWidth(String width) {
            this.width = width;
        }

        @Override
        public final Builder width(String width) {
            this.width = width;
            return this;
        }

        public PivotTableDataPathOption build() {
            return new PivotTableDataPathOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PivotTableDataPathOption> {
        public Builder dataPathList(Collection<DataPathValue> var1);

        public Builder dataPathList(DataPathValue ... var1);

        public Builder dataPathList(Consumer<DataPathValue.Builder> ... var1);

        public Builder width(String var1);
    }
}

