/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.LookbackWindowSizeUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LookbackWindow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LookbackWindow> {
    private static final SdkField<String> COLUMN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ColumnName").getter(LookbackWindow.getter(LookbackWindow::columnName)).setter(LookbackWindow.setter(Builder::columnName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnName").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Size").getter(LookbackWindow.getter(LookbackWindow::size)).setter(LookbackWindow.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final SdkField<String> SIZE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SizeUnit").getter(LookbackWindow.getter(LookbackWindow::sizeUnitAsString)).setter(LookbackWindow.setter(Builder::sizeUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_NAME_FIELD, SIZE_FIELD, SIZE_UNIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ColumnName", COLUMN_NAME_FIELD);
            this.put("Size", SIZE_FIELD);
            this.put("SizeUnit", SIZE_UNIT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String columnName;
    private final Long size;
    private final String sizeUnit;

    private LookbackWindow(BuilderImpl builder) {
        this.columnName = builder.columnName;
        this.size = builder.size;
        this.sizeUnit = builder.sizeUnit;
    }

    public final String columnName() {
        return this.columnName;
    }

    public final Long size() {
        return this.size;
    }

    public final LookbackWindowSizeUnit sizeUnit() {
        return LookbackWindowSizeUnit.fromValue(this.sizeUnit);
    }

    public final String sizeUnitAsString() {
        return this.sizeUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.columnName());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeUnitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LookbackWindow)) {
            return false;
        }
        LookbackWindow other = (LookbackWindow)obj;
        return Objects.equals(this.columnName(), other.columnName()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.sizeUnitAsString(), other.sizeUnitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LookbackWindow").add("ColumnName", (Object)this.columnName()).add("Size", (Object)this.size()).add("SizeUnit", (Object)this.sizeUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ColumnName": {
                return Optional.ofNullable(clazz.cast(this.columnName()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "SizeUnit": {
                return Optional.ofNullable(clazz.cast(this.sizeUnitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LookbackWindow, T> g) {
        return obj -> g.apply((LookbackWindow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String columnName;
        private Long size;
        private String sizeUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(LookbackWindow model) {
            this.columnName(model.columnName);
            this.size(model.size);
            this.sizeUnit(model.sizeUnit);
        }

        public final String getColumnName() {
            return this.columnName;
        }

        public final void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        @Override
        public final Builder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public final Long getSize() {
            return this.size;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final String getSizeUnit() {
            return this.sizeUnit;
        }

        public final void setSizeUnit(String sizeUnit) {
            this.sizeUnit = sizeUnit;
        }

        @Override
        public final Builder sizeUnit(String sizeUnit) {
            this.sizeUnit = sizeUnit;
            return this;
        }

        @Override
        public final Builder sizeUnit(LookbackWindowSizeUnit sizeUnit) {
            this.sizeUnit(sizeUnit == null ? null : sizeUnit.toString());
            return this;
        }

        public LookbackWindow build() {
            return new LookbackWindow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LookbackWindow> {
        public Builder columnName(String var1);

        public Builder size(Long var1);

        public Builder sizeUnit(String var1);

        public Builder sizeUnit(LookbackWindowSizeUnit var1);
    }
}

