/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Icon {
    CARET_UP("CARET_UP"),
    CARET_DOWN("CARET_DOWN"),
    PLUS("PLUS"),
    MINUS("MINUS"),
    ARROW_UP("ARROW_UP"),
    ARROW_DOWN("ARROW_DOWN"),
    ARROW_LEFT("ARROW_LEFT"),
    ARROW_UP_LEFT("ARROW_UP_LEFT"),
    ARROW_DOWN_LEFT("ARROW_DOWN_LEFT"),
    ARROW_RIGHT("ARROW_RIGHT"),
    ARROW_UP_RIGHT("ARROW_UP_RIGHT"),
    ARROW_DOWN_RIGHT("ARROW_DOWN_RIGHT"),
    FACE_UP("FACE_UP"),
    FACE_DOWN("FACE_DOWN"),
    FACE_FLAT("FACE_FLAT"),
    ONE_BAR("ONE_BAR"),
    TWO_BAR("TWO_BAR"),
    THREE_BAR("THREE_BAR"),
    CIRCLE("CIRCLE"),
    TRIANGLE("TRIANGLE"),
    SQUARE("SQUARE"),
    FLAG("FLAG"),
    THUMBS_UP("THUMBS_UP"),
    THUMBS_DOWN("THUMBS_DOWN"),
    CHECKMARK("CHECKMARK"),
    X("X"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Icon> VALUE_MAP;
    private final String value;

    private Icon(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Icon fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Icon> knownValues() {
        EnumSet<Icon> knownValues = EnumSet.allOf(Icon.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Icon.class, Icon::toString);
    }
}

