/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptions;
import software.amazon.awssdk.services.quicksight.model.FieldSortOptionsListCopier;
import software.amazon.awssdk.services.quicksight.model.ItemsLimitConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HeatMapSortConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HeatMapSortConfiguration> {
    private static final SdkField<List<FieldSortOptions>> HEAT_MAP_ROW_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HeatMapRowSort").getter(HeatMapSortConfiguration.getter(HeatMapSortConfiguration::heatMapRowSort)).setter(HeatMapSortConfiguration.setter(Builder::heatMapRowSort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatMapRowSort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FieldSortOptions>> HEAT_MAP_COLUMN_SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HeatMapColumnSort").getter(HeatMapSortConfiguration.getter(HeatMapSortConfiguration::heatMapColumnSort)).setter(HeatMapSortConfiguration.setter(Builder::heatMapColumnSort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatMapColumnSort").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldSortOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ItemsLimitConfiguration> HEAT_MAP_ROW_ITEMS_LIMIT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HeatMapRowItemsLimitConfiguration").getter(HeatMapSortConfiguration.getter(HeatMapSortConfiguration::heatMapRowItemsLimitConfiguration)).setter(HeatMapSortConfiguration.setter(Builder::heatMapRowItemsLimitConfiguration)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatMapRowItemsLimitConfiguration").build()}).build();
    private static final SdkField<ItemsLimitConfiguration> HEAT_MAP_COLUMN_ITEMS_LIMIT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HeatMapColumnItemsLimitConfiguration").getter(HeatMapSortConfiguration.getter(HeatMapSortConfiguration::heatMapColumnItemsLimitConfiguration)).setter(HeatMapSortConfiguration.setter(Builder::heatMapColumnItemsLimitConfiguration)).constructor(ItemsLimitConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeatMapColumnItemsLimitConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEAT_MAP_ROW_SORT_FIELD, HEAT_MAP_COLUMN_SORT_FIELD, HEAT_MAP_ROW_ITEMS_LIMIT_CONFIGURATION_FIELD, HEAT_MAP_COLUMN_ITEMS_LIMIT_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HeatMapRowSort", HEAT_MAP_ROW_SORT_FIELD);
            this.put("HeatMapColumnSort", HEAT_MAP_COLUMN_SORT_FIELD);
            this.put("HeatMapRowItemsLimitConfiguration", HEAT_MAP_ROW_ITEMS_LIMIT_CONFIGURATION_FIELD);
            this.put("HeatMapColumnItemsLimitConfiguration", HEAT_MAP_COLUMN_ITEMS_LIMIT_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<FieldSortOptions> heatMapRowSort;
    private final List<FieldSortOptions> heatMapColumnSort;
    private final ItemsLimitConfiguration heatMapRowItemsLimitConfiguration;
    private final ItemsLimitConfiguration heatMapColumnItemsLimitConfiguration;

    private HeatMapSortConfiguration(BuilderImpl builder) {
        this.heatMapRowSort = builder.heatMapRowSort;
        this.heatMapColumnSort = builder.heatMapColumnSort;
        this.heatMapRowItemsLimitConfiguration = builder.heatMapRowItemsLimitConfiguration;
        this.heatMapColumnItemsLimitConfiguration = builder.heatMapColumnItemsLimitConfiguration;
    }

    public final boolean hasHeatMapRowSort() {
        return this.heatMapRowSort != null && !(this.heatMapRowSort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> heatMapRowSort() {
        return this.heatMapRowSort;
    }

    public final boolean hasHeatMapColumnSort() {
        return this.heatMapColumnSort != null && !(this.heatMapColumnSort instanceof SdkAutoConstructList);
    }

    public final List<FieldSortOptions> heatMapColumnSort() {
        return this.heatMapColumnSort;
    }

    public final ItemsLimitConfiguration heatMapRowItemsLimitConfiguration() {
        return this.heatMapRowItemsLimitConfiguration;
    }

    public final ItemsLimitConfiguration heatMapColumnItemsLimitConfiguration() {
        return this.heatMapColumnItemsLimitConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeatMapRowSort() ? this.heatMapRowSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeatMapColumnSort() ? this.heatMapColumnSort() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.heatMapRowItemsLimitConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.heatMapColumnItemsLimitConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HeatMapSortConfiguration)) {
            return false;
        }
        HeatMapSortConfiguration other = (HeatMapSortConfiguration)obj;
        return this.hasHeatMapRowSort() == other.hasHeatMapRowSort() && Objects.equals(this.heatMapRowSort(), other.heatMapRowSort()) && this.hasHeatMapColumnSort() == other.hasHeatMapColumnSort() && Objects.equals(this.heatMapColumnSort(), other.heatMapColumnSort()) && Objects.equals(this.heatMapRowItemsLimitConfiguration(), other.heatMapRowItemsLimitConfiguration()) && Objects.equals(this.heatMapColumnItemsLimitConfiguration(), other.heatMapColumnItemsLimitConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"HeatMapSortConfiguration").add("HeatMapRowSort", this.hasHeatMapRowSort() ? this.heatMapRowSort() : null).add("HeatMapColumnSort", this.hasHeatMapColumnSort() ? this.heatMapColumnSort() : null).add("HeatMapRowItemsLimitConfiguration", (Object)this.heatMapRowItemsLimitConfiguration()).add("HeatMapColumnItemsLimitConfiguration", (Object)this.heatMapColumnItemsLimitConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HeatMapRowSort": {
                return Optional.ofNullable(clazz.cast(this.heatMapRowSort()));
            }
            case "HeatMapColumnSort": {
                return Optional.ofNullable(clazz.cast(this.heatMapColumnSort()));
            }
            case "HeatMapRowItemsLimitConfiguration": {
                return Optional.ofNullable(clazz.cast(this.heatMapRowItemsLimitConfiguration()));
            }
            case "HeatMapColumnItemsLimitConfiguration": {
                return Optional.ofNullable(clazz.cast(this.heatMapColumnItemsLimitConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<HeatMapSortConfiguration, T> g) {
        return obj -> g.apply((HeatMapSortConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<FieldSortOptions> heatMapRowSort = DefaultSdkAutoConstructList.getInstance();
        private List<FieldSortOptions> heatMapColumnSort = DefaultSdkAutoConstructList.getInstance();
        private ItemsLimitConfiguration heatMapRowItemsLimitConfiguration;
        private ItemsLimitConfiguration heatMapColumnItemsLimitConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(HeatMapSortConfiguration model) {
            this.heatMapRowSort(model.heatMapRowSort);
            this.heatMapColumnSort(model.heatMapColumnSort);
            this.heatMapRowItemsLimitConfiguration(model.heatMapRowItemsLimitConfiguration);
            this.heatMapColumnItemsLimitConfiguration(model.heatMapColumnItemsLimitConfiguration);
        }

        public final List<FieldSortOptions.Builder> getHeatMapRowSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.heatMapRowSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeatMapRowSort(Collection<FieldSortOptions.BuilderImpl> heatMapRowSort) {
            this.heatMapRowSort = FieldSortOptionsListCopier.copyFromBuilder(heatMapRowSort);
        }

        @Override
        public final Builder heatMapRowSort(Collection<FieldSortOptions> heatMapRowSort) {
            this.heatMapRowSort = FieldSortOptionsListCopier.copy(heatMapRowSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder heatMapRowSort(FieldSortOptions ... heatMapRowSort) {
            this.heatMapRowSort(Arrays.asList(heatMapRowSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder heatMapRowSort(Consumer<FieldSortOptions.Builder> ... heatMapRowSort) {
            this.heatMapRowSort(Stream.of(heatMapRowSort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FieldSortOptions.Builder> getHeatMapColumnSort() {
            List<FieldSortOptions.Builder> result = FieldSortOptionsListCopier.copyToBuilder(this.heatMapColumnSort);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHeatMapColumnSort(Collection<FieldSortOptions.BuilderImpl> heatMapColumnSort) {
            this.heatMapColumnSort = FieldSortOptionsListCopier.copyFromBuilder(heatMapColumnSort);
        }

        @Override
        public final Builder heatMapColumnSort(Collection<FieldSortOptions> heatMapColumnSort) {
            this.heatMapColumnSort = FieldSortOptionsListCopier.copy(heatMapColumnSort);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder heatMapColumnSort(FieldSortOptions ... heatMapColumnSort) {
            this.heatMapColumnSort(Arrays.asList(heatMapColumnSort));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder heatMapColumnSort(Consumer<FieldSortOptions.Builder> ... heatMapColumnSort) {
            this.heatMapColumnSort(Stream.of(heatMapColumnSort).map(c -> (FieldSortOptions)((FieldSortOptions.Builder)FieldSortOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ItemsLimitConfiguration.Builder getHeatMapRowItemsLimitConfiguration() {
            return this.heatMapRowItemsLimitConfiguration != null ? this.heatMapRowItemsLimitConfiguration.toBuilder() : null;
        }

        public final void setHeatMapRowItemsLimitConfiguration(ItemsLimitConfiguration.BuilderImpl heatMapRowItemsLimitConfiguration) {
            this.heatMapRowItemsLimitConfiguration = heatMapRowItemsLimitConfiguration != null ? heatMapRowItemsLimitConfiguration.build() : null;
        }

        @Override
        public final Builder heatMapRowItemsLimitConfiguration(ItemsLimitConfiguration heatMapRowItemsLimitConfiguration) {
            this.heatMapRowItemsLimitConfiguration = heatMapRowItemsLimitConfiguration;
            return this;
        }

        public final ItemsLimitConfiguration.Builder getHeatMapColumnItemsLimitConfiguration() {
            return this.heatMapColumnItemsLimitConfiguration != null ? this.heatMapColumnItemsLimitConfiguration.toBuilder() : null;
        }

        public final void setHeatMapColumnItemsLimitConfiguration(ItemsLimitConfiguration.BuilderImpl heatMapColumnItemsLimitConfiguration) {
            this.heatMapColumnItemsLimitConfiguration = heatMapColumnItemsLimitConfiguration != null ? heatMapColumnItemsLimitConfiguration.build() : null;
        }

        @Override
        public final Builder heatMapColumnItemsLimitConfiguration(ItemsLimitConfiguration heatMapColumnItemsLimitConfiguration) {
            this.heatMapColumnItemsLimitConfiguration = heatMapColumnItemsLimitConfiguration;
            return this;
        }

        public HeatMapSortConfiguration build() {
            return new HeatMapSortConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HeatMapSortConfiguration> {
        public Builder heatMapRowSort(Collection<FieldSortOptions> var1);

        public Builder heatMapRowSort(FieldSortOptions ... var1);

        public Builder heatMapRowSort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder heatMapColumnSort(Collection<FieldSortOptions> var1);

        public Builder heatMapColumnSort(FieldSortOptions ... var1);

        public Builder heatMapColumnSort(Consumer<FieldSortOptions.Builder> ... var1);

        public Builder heatMapRowItemsLimitConfiguration(ItemsLimitConfiguration var1);

        default public Builder heatMapRowItemsLimitConfiguration(Consumer<ItemsLimitConfiguration.Builder> heatMapRowItemsLimitConfiguration) {
            return this.heatMapRowItemsLimitConfiguration((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(heatMapRowItemsLimitConfiguration)).build());
        }

        public Builder heatMapColumnItemsLimitConfiguration(ItemsLimitConfiguration var1);

        default public Builder heatMapColumnItemsLimitConfiguration(Consumer<ItemsLimitConfiguration.Builder> heatMapColumnItemsLimitConfiguration) {
            return this.heatMapColumnItemsLimitConfiguration((ItemsLimitConfiguration)((ItemsLimitConfiguration.Builder)ItemsLimitConfiguration.builder().applyMutation(heatMapColumnItemsLimitConfiguration)).build());
        }
    }
}

