/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.proton.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.proton.ProtonClient;
import software.amazon.awssdk.services.proton.internal.UserAgentUtils;
import software.amazon.awssdk.services.proton.model.EnvironmentTemplateSummary;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesRequest;
import software.amazon.awssdk.services.proton.model.ListEnvironmentTemplatesResponse;

public class ListEnvironmentTemplatesIterable
implements SdkIterable<ListEnvironmentTemplatesResponse> {
    private final ProtonClient client;
    private final ListEnvironmentTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentTemplatesIterable(ProtonClient client, ListEnvironmentTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentTemplatesResponseFetcher();
    }

    public Iterator<ListEnvironmentTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentTemplateSummary> templates() {
        Function<ListEnvironmentTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templates() != null) {
                return response.templates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentTemplatesResponseFetcher
    implements SyncPageFetcher<ListEnvironmentTemplatesResponse> {
        private ListEnvironmentTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentTemplatesResponse nextPage(ListEnvironmentTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentTemplatesIterable.this.client.listEnvironmentTemplates(ListEnvironmentTemplatesIterable.this.firstRequest);
            }
            return ListEnvironmentTemplatesIterable.this.client.listEnvironmentTemplates((ListEnvironmentTemplatesRequest)((Object)ListEnvironmentTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

