/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BatchResourceRequirementType {
    GPU("GPU"),
    MEMORY("MEMORY"),
    VCPU("VCPU"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BatchResourceRequirementType> VALUE_MAP;
    private final String value;

    private BatchResourceRequirementType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BatchResourceRequirementType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BatchResourceRequirementType> knownValues() {
        EnumSet<BatchResourceRequirementType> knownValues = EnumSet.allOf(BatchResourceRequirementType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BatchResourceRequirementType.class, BatchResourceRequirementType::toString);
    }
}

