/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2Client;
import software.amazon.awssdk.services.pinpointsmsvoicev2.internal.UserAgentUtils;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsRequest;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeProtectConfigurationsResponse;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.ProtectConfigurationInformation;

public class DescribeProtectConfigurationsIterable
implements SdkIterable<DescribeProtectConfigurationsResponse> {
    private final PinpointSmsVoiceV2Client client;
    private final DescribeProtectConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeProtectConfigurationsIterable(PinpointSmsVoiceV2Client client, DescribeProtectConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeProtectConfigurationsResponseFetcher();
    }

    public Iterator<DescribeProtectConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ProtectConfigurationInformation> protectConfigurations() {
        Function<DescribeProtectConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.protectConfigurations() != null) {
                return response.protectConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeProtectConfigurationsResponseFetcher
    implements SyncPageFetcher<DescribeProtectConfigurationsResponse> {
        private DescribeProtectConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeProtectConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeProtectConfigurationsResponse nextPage(DescribeProtectConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeProtectConfigurationsIterable.this.client.describeProtectConfigurations(DescribeProtectConfigurationsIterable.this.firstRequest);
            }
            return DescribeProtectConfigurationsIterable.this.client.describeProtectConfigurations((DescribeProtectConfigurationsRequest)((Object)DescribeProtectConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

