/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageTypeListCopier;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.PinpointSmsVoiceV2Request;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.Tag;
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestSenderIdRequest
extends PinpointSmsVoiceV2Request
implements ToCopyableBuilder<Builder, RequestSenderIdRequest> {
    private static final SdkField<String> SENDER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SenderId").getter(RequestSenderIdRequest.getter(RequestSenderIdRequest::senderId)).setter(RequestSenderIdRequest.setter(Builder::senderId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderId").build()}).build();
    private static final SdkField<String> ISO_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IsoCountryCode").getter(RequestSenderIdRequest.getter(RequestSenderIdRequest::isoCountryCode)).setter(RequestSenderIdRequest.setter(Builder::isoCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsoCountryCode").build()}).build();
    private static final SdkField<List<String>> MESSAGE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MessageTypes").getter(RequestSenderIdRequest.getter(RequestSenderIdRequest::messageTypesAsStrings)).setter(RequestSenderIdRequest.setter(Builder::messageTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtectionEnabled").getter(RequestSenderIdRequest.getter(RequestSenderIdRequest::deletionProtectionEnabled)).setter(RequestSenderIdRequest.setter(Builder::deletionProtectionEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtectionEnabled").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RequestSenderIdRequest.getter(RequestSenderIdRequest::tags)).setter(RequestSenderIdRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(RequestSenderIdRequest.getter(RequestSenderIdRequest::clientToken)).setter(RequestSenderIdRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SENDER_ID_FIELD, ISO_COUNTRY_CODE_FIELD, MESSAGE_TYPES_FIELD, DELETION_PROTECTION_ENABLED_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SenderId", SENDER_ID_FIELD);
            this.put("IsoCountryCode", ISO_COUNTRY_CODE_FIELD);
            this.put("MessageTypes", MESSAGE_TYPES_FIELD);
            this.put("DeletionProtectionEnabled", DELETION_PROTECTION_ENABLED_FIELD);
            this.put("Tags", TAGS_FIELD);
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
        }
    });
    private final String senderId;
    private final String isoCountryCode;
    private final List<String> messageTypes;
    private final Boolean deletionProtectionEnabled;
    private final List<Tag> tags;
    private final String clientToken;

    private RequestSenderIdRequest(BuilderImpl builder) {
        super(builder);
        this.senderId = builder.senderId;
        this.isoCountryCode = builder.isoCountryCode;
        this.messageTypes = builder.messageTypes;
        this.deletionProtectionEnabled = builder.deletionProtectionEnabled;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
    }

    public final String senderId() {
        return this.senderId;
    }

    public final String isoCountryCode() {
        return this.isoCountryCode;
    }

    public final List<MessageType> messageTypes() {
        return MessageTypeListCopier.copyStringToEnum(this.messageTypes);
    }

    public final boolean hasMessageTypes() {
        return this.messageTypes != null && !(this.messageTypes instanceof SdkAutoConstructList);
    }

    public final List<String> messageTypesAsStrings() {
        return this.messageTypes;
    }

    public final Boolean deletionProtectionEnabled() {
        return this.deletionProtectionEnabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.senderId());
        hashCode = 31 * hashCode + Objects.hashCode(this.isoCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMessageTypes() ? this.messageTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestSenderIdRequest)) {
            return false;
        }
        RequestSenderIdRequest other = (RequestSenderIdRequest)((Object)obj);
        return Objects.equals(this.senderId(), other.senderId()) && Objects.equals(this.isoCountryCode(), other.isoCountryCode()) && this.hasMessageTypes() == other.hasMessageTypes() && Objects.equals(this.messageTypesAsStrings(), other.messageTypesAsStrings()) && Objects.equals(this.deletionProtectionEnabled(), other.deletionProtectionEnabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"RequestSenderIdRequest").add("SenderId", (Object)this.senderId()).add("IsoCountryCode", (Object)this.isoCountryCode()).add("MessageTypes", this.hasMessageTypes() ? this.messageTypesAsStrings() : null).add("DeletionProtectionEnabled", (Object)this.deletionProtectionEnabled()).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SenderId": {
                return Optional.ofNullable(clazz.cast(this.senderId()));
            }
            case "IsoCountryCode": {
                return Optional.ofNullable(clazz.cast(this.isoCountryCode()));
            }
            case "MessageTypes": {
                return Optional.ofNullable(clazz.cast(this.messageTypesAsStrings()));
            }
            case "DeletionProtectionEnabled": {
                return Optional.ofNullable(clazz.cast(this.deletionProtectionEnabled()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RequestSenderIdRequest, T> g) {
        return obj -> g.apply((RequestSenderIdRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointSmsVoiceV2Request.BuilderImpl
    implements Builder {
        private String senderId;
        private String isoCountryCode;
        private List<String> messageTypes = DefaultSdkAutoConstructList.getInstance();
        private Boolean deletionProtectionEnabled;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestSenderIdRequest model) {
            super(model);
            this.senderId(model.senderId);
            this.isoCountryCode(model.isoCountryCode);
            this.messageTypesWithStrings(model.messageTypes);
            this.deletionProtectionEnabled(model.deletionProtectionEnabled);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
        }

        public final String getSenderId() {
            return this.senderId;
        }

        public final void setSenderId(String senderId) {
            this.senderId = senderId;
        }

        @Override
        public final Builder senderId(String senderId) {
            this.senderId = senderId;
            return this;
        }

        public final String getIsoCountryCode() {
            return this.isoCountryCode;
        }

        public final void setIsoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
        }

        @Override
        public final Builder isoCountryCode(String isoCountryCode) {
            this.isoCountryCode = isoCountryCode;
            return this;
        }

        public final Collection<String> getMessageTypes() {
            if (this.messageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.messageTypes;
        }

        public final void setMessageTypes(Collection<String> messageTypes) {
            this.messageTypes = MessageTypeListCopier.copy(messageTypes);
        }

        @Override
        public final Builder messageTypesWithStrings(Collection<String> messageTypes) {
            this.messageTypes = MessageTypeListCopier.copy(messageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTypesWithStrings(String ... messageTypes) {
            this.messageTypesWithStrings(Arrays.asList(messageTypes));
            return this;
        }

        @Override
        public final Builder messageTypes(Collection<MessageType> messageTypes) {
            this.messageTypes = MessageTypeListCopier.copyEnumToString(messageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageTypes(MessageType ... messageTypes) {
            this.messageTypes(Arrays.asList(messageTypes));
            return this;
        }

        public final Boolean getDeletionProtectionEnabled() {
            return this.deletionProtectionEnabled;
        }

        public final void setDeletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
        }

        @Override
        public final Builder deletionProtectionEnabled(Boolean deletionProtectionEnabled) {
            this.deletionProtectionEnabled = deletionProtectionEnabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RequestSenderIdRequest build() {
            return new RequestSenderIdRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PinpointSmsVoiceV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RequestSenderIdRequest> {
        public Builder senderId(String var1);

        public Builder isoCountryCode(String var1);

        public Builder messageTypesWithStrings(Collection<String> var1);

        public Builder messageTypesWithStrings(String ... var1);

        public Builder messageTypes(Collection<MessageType> var1);

        public Builder messageTypes(MessageType ... var1);

        public Builder deletionProtectionEnabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

