/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointsmsvoicev2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NumberCapability {
    SMS("SMS"),
    VOICE("VOICE"),
    MMS("MMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NumberCapability> VALUE_MAP;
    private final String value;

    private NumberCapability(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NumberCapability fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NumberCapability> knownValues() {
        EnumSet<NumberCapability> knownValues = EnumSet.allOf(NumberCapability.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NumberCapability.class, NumberCapability::toString);
    }
}

