/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.pi.model.PiRequest;
import software.amazon.awssdk.services.pi.model.RequestedDimensionListCopier;
import software.amazon.awssdk.services.pi.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDimensionKeyDetailsRequest
extends PiRequest
implements ToCopyableBuilder<Builder, GetDimensionKeyDetailsRequest> {
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceType").getter(GetDimensionKeyDetailsRequest.getter(GetDimensionKeyDetailsRequest::serviceTypeAsString)).setter(GetDimensionKeyDetailsRequest.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceType").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identifier").getter(GetDimensionKeyDetailsRequest.getter(GetDimensionKeyDetailsRequest::identifier)).setter(GetDimensionKeyDetailsRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Group").getter(GetDimensionKeyDetailsRequest.getter(GetDimensionKeyDetailsRequest::group)).setter(GetDimensionKeyDetailsRequest.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Group").build()}).build();
    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupIdentifier").getter(GetDimensionKeyDetailsRequest.getter(GetDimensionKeyDetailsRequest::groupIdentifier)).setter(GetDimensionKeyDetailsRequest.setter(Builder::groupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupIdentifier").build()}).build();
    private static final SdkField<List<String>> REQUESTED_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequestedDimensions").getter(GetDimensionKeyDetailsRequest.getter(GetDimensionKeyDetailsRequest::requestedDimensions)).setter(GetDimensionKeyDetailsRequest.setter(Builder::requestedDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedDimensions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_TYPE_FIELD, IDENTIFIER_FIELD, GROUP_FIELD, GROUP_IDENTIFIER_FIELD, REQUESTED_DIMENSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ServiceType", SERVICE_TYPE_FIELD);
            this.put("Identifier", IDENTIFIER_FIELD);
            this.put("Group", GROUP_FIELD);
            this.put("GroupIdentifier", GROUP_IDENTIFIER_FIELD);
            this.put("RequestedDimensions", REQUESTED_DIMENSIONS_FIELD);
        }
    });
    private final String serviceType;
    private final String identifier;
    private final String group;
    private final String groupIdentifier;
    private final List<String> requestedDimensions;

    private GetDimensionKeyDetailsRequest(BuilderImpl builder) {
        super(builder);
        this.serviceType = builder.serviceType;
        this.identifier = builder.identifier;
        this.group = builder.group;
        this.groupIdentifier = builder.groupIdentifier;
        this.requestedDimensions = builder.requestedDimensions;
    }

    public final ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String group() {
        return this.group;
    }

    public final String groupIdentifier() {
        return this.groupIdentifier;
    }

    public final boolean hasRequestedDimensions() {
        return this.requestedDimensions != null && !(this.requestedDimensions instanceof SdkAutoConstructList);
    }

    public final List<String> requestedDimensions() {
        return this.requestedDimensions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestedDimensions() ? this.requestedDimensions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDimensionKeyDetailsRequest)) {
            return false;
        }
        GetDimensionKeyDetailsRequest other = (GetDimensionKeyDetailsRequest)((Object)obj);
        return Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.groupIdentifier(), other.groupIdentifier()) && this.hasRequestedDimensions() == other.hasRequestedDimensions() && Objects.equals(this.requestedDimensions(), other.requestedDimensions());
    }

    public final String toString() {
        return ToString.builder((String)"GetDimensionKeyDetailsRequest").add("ServiceType", (Object)this.serviceTypeAsString()).add("Identifier", (Object)this.identifier()).add("Group", (Object)this.group()).add("GroupIdentifier", (Object)this.groupIdentifier()).add("RequestedDimensions", this.hasRequestedDimensions() ? this.requestedDimensions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "Group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "GroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.groupIdentifier()));
            }
            case "RequestedDimensions": {
                return Optional.ofNullable(clazz.cast(this.requestedDimensions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDimensionKeyDetailsRequest, T> g) {
        return obj -> g.apply((GetDimensionKeyDetailsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PiRequest.BuilderImpl
    implements Builder {
        private String serviceType;
        private String identifier;
        private String group;
        private String groupIdentifier;
        private List<String> requestedDimensions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDimensionKeyDetailsRequest model) {
            super(model);
            this.serviceType(model.serviceType);
            this.identifier(model.identifier);
            this.group(model.group);
            this.groupIdentifier(model.groupIdentifier);
            this.requestedDimensions(model.requestedDimensions);
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getGroupIdentifier() {
            return this.groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            this.groupIdentifier = groupIdentifier;
            return this;
        }

        public final Collection<String> getRequestedDimensions() {
            if (this.requestedDimensions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requestedDimensions;
        }

        public final void setRequestedDimensions(Collection<String> requestedDimensions) {
            this.requestedDimensions = RequestedDimensionListCopier.copy(requestedDimensions);
        }

        @Override
        public final Builder requestedDimensions(Collection<String> requestedDimensions) {
            this.requestedDimensions = RequestedDimensionListCopier.copy(requestedDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedDimensions(String ... requestedDimensions) {
            this.requestedDimensions(Arrays.asList(requestedDimensions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDimensionKeyDetailsRequest build() {
            return new GetDimensionKeyDetailsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PiRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDimensionKeyDetailsRequest> {
        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);

        public Builder identifier(String var1);

        public Builder group(String var1);

        public Builder groupIdentifier(String var1);

        public Builder requestedDimensions(Collection<String> var1);

        public Builder requestedDimensions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

