/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrainingType {
    AUTOMATIC("AUTOMATIC"),
    MANUAL("MANUAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrainingType> VALUE_MAP;
    private final String value;

    private TrainingType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainingType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainingType> knownValues() {
        EnumSet<TrainingType> knownValues = EnumSet.allOf(TrainingType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrainingType.class, TrainingType::toString);
    }
}

