/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VerificationFailedReason {
    INVALID_MAC("INVALID_MAC"),
    INVALID_PIN("INVALID_PIN"),
    INVALID_VALIDATION_DATA("INVALID_VALIDATION_DATA"),
    INVALID_AUTH_REQUEST_CRYPTOGRAM("INVALID_AUTH_REQUEST_CRYPTOGRAM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VerificationFailedReason> VALUE_MAP;
    private final String value;

    private VerificationFailedReason(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VerificationFailedReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VerificationFailedReason> knownValues() {
        EnumSet<VerificationFailedReason> knownValues = EnumSet.allOf(VerificationFailedReason.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VerificationFailedReason.class, VerificationFailedReason::toString);
    }
}

