/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.PackageImportJob;
import software.amazon.awssdk.services.panorama.model.PackageImportJobListCopier;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPackageImportJobsResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, ListPackageImportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPackageImportJobsResponse.getter(ListPackageImportJobsResponse::nextToken)).setter(ListPackageImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<PackageImportJob>> PACKAGE_IMPORT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PackageImportJobs").getter(ListPackageImportJobsResponse.getter(ListPackageImportJobsResponse::packageImportJobs)).setter(ListPackageImportJobsResponse.setter(Builder::packageImportJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageImportJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageImportJob::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PACKAGE_IMPORT_JOBS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("PackageImportJobs", PACKAGE_IMPORT_JOBS_FIELD);
        }
    });
    private final String nextToken;
    private final List<PackageImportJob> packageImportJobs;

    private ListPackageImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.packageImportJobs = builder.packageImportJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasPackageImportJobs() {
        return this.packageImportJobs != null && !(this.packageImportJobs instanceof SdkAutoConstructList);
    }

    public final List<PackageImportJob> packageImportJobs() {
        return this.packageImportJobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPackageImportJobs() ? this.packageImportJobs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageImportJobsResponse)) {
            return false;
        }
        ListPackageImportJobsResponse other = (ListPackageImportJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasPackageImportJobs() == other.hasPackageImportJobs() && Objects.equals(this.packageImportJobs(), other.packageImportJobs());
    }

    public final String toString() {
        return ToString.builder((String)"ListPackageImportJobsResponse").add("NextToken", (Object)this.nextToken()).add("PackageImportJobs", this.hasPackageImportJobs() ? this.packageImportJobs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "PackageImportJobs": {
                return Optional.ofNullable(clazz.cast(this.packageImportJobs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageImportJobsResponse, T> g) {
        return obj -> g.apply((ListPackageImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<PackageImportJob> packageImportJobs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageImportJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.packageImportJobs(model.packageImportJobs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<PackageImportJob.Builder> getPackageImportJobs() {
            List<PackageImportJob.Builder> result = PackageImportJobListCopier.copyToBuilder(this.packageImportJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPackageImportJobs(Collection<PackageImportJob.BuilderImpl> packageImportJobs) {
            this.packageImportJobs = PackageImportJobListCopier.copyFromBuilder(packageImportJobs);
        }

        @Override
        public final Builder packageImportJobs(Collection<PackageImportJob> packageImportJobs) {
            this.packageImportJobs = PackageImportJobListCopier.copy(packageImportJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageImportJobs(PackageImportJob ... packageImportJobs) {
            this.packageImportJobs(Arrays.asList(packageImportJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageImportJobs(Consumer<PackageImportJob.Builder> ... packageImportJobs) {
            this.packageImportJobs(Stream.of(packageImportJobs).map(c -> (PackageImportJob)((PackageImportJob.Builder)PackageImportJob.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListPackageImportJobsResponse build() {
            return new ListPackageImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPackageImportJobsResponse> {
        public Builder nextToken(String var1);

        public Builder packageImportJobs(Collection<PackageImportJob> var1);

        public Builder packageImportJobs(PackageImportJob ... var1);

        public Builder packageImportJobs(Consumer<PackageImportJob.Builder> ... var1);
    }
}

