/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.osis.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.osis.model.ChangeProgressStage;
import software.amazon.awssdk.services.osis.model.ChangeProgressStageListCopier;
import software.amazon.awssdk.services.osis.model.ChangeProgressStatuses;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChangeProgressStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChangeProgressStatus> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ChangeProgressStatus.getter(ChangeProgressStatus::startTime)).setter(ChangeProgressStatus.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ChangeProgressStatus.getter(ChangeProgressStatus::statusAsString)).setter(ChangeProgressStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Integer> TOTAL_NUMBER_OF_STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalNumberOfStages").getter(ChangeProgressStatus.getter(ChangeProgressStatus::totalNumberOfStages)).setter(ChangeProgressStatus.setter(Builder::totalNumberOfStages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfStages").build()}).build();
    private static final SdkField<List<ChangeProgressStage>> CHANGE_PROGRESS_STAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChangeProgressStages").getter(ChangeProgressStatus.getter(ChangeProgressStatus::changeProgressStages)).setter(ChangeProgressStatus.setter(Builder::changeProgressStages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressStages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangeProgressStage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD, STATUS_FIELD, TOTAL_NUMBER_OF_STAGES_FIELD, CHANGE_PROGRESS_STAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StartTime", START_TIME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("TotalNumberOfStages", TOTAL_NUMBER_OF_STAGES_FIELD);
            this.put("ChangeProgressStages", CHANGE_PROGRESS_STAGES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant startTime;
    private final String status;
    private final Integer totalNumberOfStages;
    private final List<ChangeProgressStage> changeProgressStages;

    private ChangeProgressStatus(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.totalNumberOfStages = builder.totalNumberOfStages;
        this.changeProgressStages = builder.changeProgressStages;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final ChangeProgressStatuses status() {
        return ChangeProgressStatuses.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer totalNumberOfStages() {
        return this.totalNumberOfStages;
    }

    public final boolean hasChangeProgressStages() {
        return this.changeProgressStages != null && !(this.changeProgressStages instanceof SdkAutoConstructList);
    }

    public final List<ChangeProgressStage> changeProgressStages() {
        return this.changeProgressStages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalNumberOfStages());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChangeProgressStages() ? this.changeProgressStages() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeProgressStatus)) {
            return false;
        }
        ChangeProgressStatus other = (ChangeProgressStatus)obj;
        return Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.totalNumberOfStages(), other.totalNumberOfStages()) && this.hasChangeProgressStages() == other.hasChangeProgressStages() && Objects.equals(this.changeProgressStages(), other.changeProgressStages());
    }

    public final String toString() {
        return ToString.builder((String)"ChangeProgressStatus").add("StartTime", (Object)this.startTime()).add("Status", (Object)this.statusAsString()).add("TotalNumberOfStages", (Object)this.totalNumberOfStages()).add("ChangeProgressStages", this.hasChangeProgressStages() ? this.changeProgressStages() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TotalNumberOfStages": {
                return Optional.ofNullable(clazz.cast(this.totalNumberOfStages()));
            }
            case "ChangeProgressStages": {
                return Optional.ofNullable(clazz.cast(this.changeProgressStages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ChangeProgressStatus, T> g) {
        return obj -> g.apply((ChangeProgressStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant startTime;
        private String status;
        private Integer totalNumberOfStages;
        private List<ChangeProgressStage> changeProgressStages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeProgressStatus model) {
            this.startTime(model.startTime);
            this.status(model.status);
            this.totalNumberOfStages(model.totalNumberOfStages);
            this.changeProgressStages(model.changeProgressStages);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeProgressStatuses status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getTotalNumberOfStages() {
            return this.totalNumberOfStages;
        }

        public final void setTotalNumberOfStages(Integer totalNumberOfStages) {
            this.totalNumberOfStages = totalNumberOfStages;
        }

        @Override
        public final Builder totalNumberOfStages(Integer totalNumberOfStages) {
            this.totalNumberOfStages = totalNumberOfStages;
            return this;
        }

        public final List<ChangeProgressStage.Builder> getChangeProgressStages() {
            List<ChangeProgressStage.Builder> result = ChangeProgressStageListCopier.copyToBuilder(this.changeProgressStages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeProgressStages(Collection<ChangeProgressStage.BuilderImpl> changeProgressStages) {
            this.changeProgressStages = ChangeProgressStageListCopier.copyFromBuilder(changeProgressStages);
        }

        @Override
        public final Builder changeProgressStages(Collection<ChangeProgressStage> changeProgressStages) {
            this.changeProgressStages = ChangeProgressStageListCopier.copy(changeProgressStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeProgressStages(ChangeProgressStage ... changeProgressStages) {
            this.changeProgressStages(Arrays.asList(changeProgressStages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeProgressStages(Consumer<ChangeProgressStage.Builder> ... changeProgressStages) {
            this.changeProgressStages(Stream.of(changeProgressStages).map(c -> (ChangeProgressStage)((ChangeProgressStage.Builder)ChangeProgressStage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ChangeProgressStatus build() {
            return new ChangeProgressStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChangeProgressStatus> {
        public Builder startTime(Instant var1);

        public Builder status(String var1);

        public Builder status(ChangeProgressStatuses var1);

        public Builder totalNumberOfStages(Integer var1);

        public Builder changeProgressStages(Collection<ChangeProgressStage> var1);

        public Builder changeProgressStages(ChangeProgressStage ... var1);

        public Builder changeProgressStages(Consumer<ChangeProgressStage.Builder> ... var1);
    }
}

