/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetachElasticLoadBalancerRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DetachElasticLoadBalancerRequest> {
    private static final SdkField<String> ELASTIC_LOAD_BALANCER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticLoadBalancerName").getter(DetachElasticLoadBalancerRequest.getter(DetachElasticLoadBalancerRequest::elasticLoadBalancerName)).setter(DetachElasticLoadBalancerRequest.setter(Builder::elasticLoadBalancerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticLoadBalancerName").build()}).build();
    private static final SdkField<String> LAYER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LayerId").getter(DetachElasticLoadBalancerRequest.getter(DetachElasticLoadBalancerRequest::layerId)).setter(DetachElasticLoadBalancerRequest.setter(Builder::layerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_LOAD_BALANCER_NAME_FIELD, LAYER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ElasticLoadBalancerName", ELASTIC_LOAD_BALANCER_NAME_FIELD);
            this.put("LayerId", LAYER_ID_FIELD);
        }
    });
    private final String elasticLoadBalancerName;
    private final String layerId;

    private DetachElasticLoadBalancerRequest(BuilderImpl builder) {
        super(builder);
        this.elasticLoadBalancerName = builder.elasticLoadBalancerName;
        this.layerId = builder.layerId;
    }

    public final String elasticLoadBalancerName() {
        return this.elasticLoadBalancerName;
    }

    public final String layerId() {
        return this.layerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticLoadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachElasticLoadBalancerRequest)) {
            return false;
        }
        DetachElasticLoadBalancerRequest other = (DetachElasticLoadBalancerRequest)((Object)obj);
        return Objects.equals(this.elasticLoadBalancerName(), other.elasticLoadBalancerName()) && Objects.equals(this.layerId(), other.layerId());
    }

    public final String toString() {
        return ToString.builder((String)"DetachElasticLoadBalancerRequest").add("ElasticLoadBalancerName", (Object)this.elasticLoadBalancerName()).add("LayerId", (Object)this.layerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ElasticLoadBalancerName": {
                return Optional.ofNullable(clazz.cast(this.elasticLoadBalancerName()));
            }
            case "LayerId": {
                return Optional.ofNullable(clazz.cast(this.layerId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DetachElasticLoadBalancerRequest, T> g) {
        return obj -> g.apply((DetachElasticLoadBalancerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String elasticLoadBalancerName;
        private String layerId;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachElasticLoadBalancerRequest model) {
            super(model);
            this.elasticLoadBalancerName(model.elasticLoadBalancerName);
            this.layerId(model.layerId);
        }

        public final String getElasticLoadBalancerName() {
            return this.elasticLoadBalancerName;
        }

        public final void setElasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
        }

        @Override
        public final Builder elasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
            return this;
        }

        public final String getLayerId() {
            return this.layerId;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachElasticLoadBalancerRequest build() {
            return new DetachElasticLoadBalancerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DetachElasticLoadBalancerRequest> {
        public Builder elasticLoadBalancerName(String var1);

        public Builder layerId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

