/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SecurityPolicyType {
    ENCRYPTION("encryption"),
    NETWORK("network"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SecurityPolicyType> VALUE_MAP;
    private final String value;

    private SecurityPolicyType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SecurityPolicyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SecurityPolicyType> knownValues() {
        EnumSet<SecurityPolicyType> knownValues = EnumSet.allOf(SecurityPolicyType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SecurityPolicyType.class, SecurityPolicyType::toString);
    }
}

