/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.LimitValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageTypeLimit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageTypeLimit> {
    private static final SdkField<String> LIMIT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LimitName").getter(StorageTypeLimit.getter(StorageTypeLimit::limitName)).setter(StorageTypeLimit.setter(Builder::limitName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitName").build()}).build();
    private static final SdkField<List<String>> LIMIT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LimitValues").getter(StorageTypeLimit.getter(StorageTypeLimit::limitValues)).setter(StorageTypeLimit.setter(Builder::limitValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LimitValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_NAME_FIELD, LIMIT_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LimitName", LIMIT_NAME_FIELD);
            this.put("LimitValues", LIMIT_VALUES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String limitName;
    private final List<String> limitValues;

    private StorageTypeLimit(BuilderImpl builder) {
        this.limitName = builder.limitName;
        this.limitValues = builder.limitValues;
    }

    public final String limitName() {
        return this.limitName;
    }

    public final boolean hasLimitValues() {
        return this.limitValues != null && !(this.limitValues instanceof SdkAutoConstructList);
    }

    public final List<String> limitValues() {
        return this.limitValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.limitName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLimitValues() ? this.limitValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageTypeLimit)) {
            return false;
        }
        StorageTypeLimit other = (StorageTypeLimit)obj;
        return Objects.equals(this.limitName(), other.limitName()) && this.hasLimitValues() == other.hasLimitValues() && Objects.equals(this.limitValues(), other.limitValues());
    }

    public final String toString() {
        return ToString.builder((String)"StorageTypeLimit").add("LimitName", (Object)this.limitName()).add("LimitValues", this.hasLimitValues() ? this.limitValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LimitName": {
                return Optional.ofNullable(clazz.cast(this.limitName()));
            }
            case "LimitValues": {
                return Optional.ofNullable(clazz.cast(this.limitValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StorageTypeLimit, T> g) {
        return obj -> g.apply((StorageTypeLimit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String limitName;
        private List<String> limitValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StorageTypeLimit model) {
            this.limitName(model.limitName);
            this.limitValues(model.limitValues);
        }

        public final String getLimitName() {
            return this.limitName;
        }

        public final void setLimitName(String limitName) {
            this.limitName = limitName;
        }

        @Override
        public final Builder limitName(String limitName) {
            this.limitName = limitName;
            return this;
        }

        public final Collection<String> getLimitValues() {
            if (this.limitValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.limitValues;
        }

        public final void setLimitValues(Collection<String> limitValues) {
            this.limitValues = LimitValueListCopier.copy(limitValues);
        }

        @Override
        public final Builder limitValues(Collection<String> limitValues) {
            this.limitValues = LimitValueListCopier.copy(limitValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder limitValues(String ... limitValues) {
            this.limitValues(Arrays.asList(limitValues));
            return this;
        }

        public StorageTypeLimit build() {
            return new StorageTypeLimit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageTypeLimit> {
        public Builder limitName(String var1);

        public Builder limitValues(Collection<String> var1);

        public Builder limitValues(String ... var1);
    }
}

