/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListVariantStoresRequest;
import software.amazon.awssdk.services.omics.model.ListVariantStoresResponse;
import software.amazon.awssdk.services.omics.model.VariantStoreItem;

public class ListVariantStoresIterable
implements SdkIterable<ListVariantStoresResponse> {
    private final OmicsClient client;
    private final ListVariantStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVariantStoresIterable(OmicsClient client, ListVariantStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVariantStoresResponseFetcher();
    }

    public Iterator<ListVariantStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VariantStoreItem> variantStores() {
        Function<ListVariantStoresResponse, Iterator> getIterator = response -> {
            if (response != null && response.variantStores() != null) {
                return response.variantStores().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVariantStoresResponseFetcher
    implements SyncPageFetcher<ListVariantStoresResponse> {
        private ListVariantStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListVariantStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVariantStoresResponse nextPage(ListVariantStoresResponse previousPage) {
            if (previousPage == null) {
                return ListVariantStoresIterable.this.client.listVariantStores(ListVariantStoresIterable.this.firstRequest);
            }
            return ListVariantStoresIterable.this.client.listVariantStores((ListVariantStoresRequest)((Object)ListVariantStoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

