/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListReferencesRequest;
import software.amazon.awssdk.services.omics.model.ListReferencesResponse;
import software.amazon.awssdk.services.omics.model.ReferenceListItem;

public class ListReferencesPublisher
implements SdkPublisher<ListReferencesResponse> {
    private final OmicsAsyncClient client;
    private final ListReferencesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReferencesPublisher(OmicsAsyncClient client, ListReferencesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReferencesPublisher(OmicsAsyncClient client, ListReferencesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReferencesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReferencesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReferenceListItem> references() {
        Function<ListReferencesResponse, Iterator> getIterator = response -> {
            if (response != null && response.references() != null) {
                return response.references().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReferencesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReferencesResponseFetcher
    implements AsyncPageFetcher<ListReferencesResponse> {
        private ListReferencesResponseFetcher() {
        }

        public boolean hasNextPage(ListReferencesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReferencesResponse> nextPage(ListReferencesResponse previousPage) {
            if (previousPage == null) {
                return ListReferencesPublisher.this.client.listReferences(ListReferencesPublisher.this.firstRequest);
            }
            return ListReferencesPublisher.this.client.listReferences((ListReferencesRequest)((Object)ListReferencesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

