/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequestSourcesListCopier;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobSourceItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartReferenceImportJobRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, StartReferenceImportJobRequest> {
    private static final SdkField<String> REFERENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceStoreId").getter(StartReferenceImportJobRequest.getter(StartReferenceImportJobRequest::referenceStoreId)).setter(StartReferenceImportJobRequest.setter(Builder::referenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("referenceStoreId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StartReferenceImportJobRequest.getter(StartReferenceImportJobRequest::roleArn)).setter(StartReferenceImportJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartReferenceImportJobRequest.getter(StartReferenceImportJobRequest::clientToken)).setter(StartReferenceImportJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<List<StartReferenceImportJobSourceItem>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(StartReferenceImportJobRequest.getter(StartReferenceImportJobRequest::sources)).setter(StartReferenceImportJobRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StartReferenceImportJobSourceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERENCE_STORE_ID_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("referenceStoreId", REFERENCE_STORE_ID_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("sources", SOURCES_FIELD);
        }
    });
    private final String referenceStoreId;
    private final String roleArn;
    private final String clientToken;
    private final List<StartReferenceImportJobSourceItem> sources;

    private StartReferenceImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.referenceStoreId = builder.referenceStoreId;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
        this.sources = builder.sources;
    }

    public final String referenceStoreId() {
        return this.referenceStoreId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<StartReferenceImportJobSourceItem> sources() {
        return this.sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReferenceImportJobRequest)) {
            return false;
        }
        StartReferenceImportJobRequest other = (StartReferenceImportJobRequest)((Object)obj);
        return Objects.equals(this.referenceStoreId(), other.referenceStoreId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public final String toString() {
        return ToString.builder((String)"StartReferenceImportJobRequest").add("ReferenceStoreId", (Object)this.referenceStoreId()).add("RoleArn", (Object)this.roleArn()).add("ClientToken", (Object)this.clientToken()).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "referenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.referenceStoreId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartReferenceImportJobRequest, T> g) {
        return obj -> g.apply((StartReferenceImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String referenceStoreId;
        private String roleArn;
        private String clientToken;
        private List<StartReferenceImportJobSourceItem> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartReferenceImportJobRequest model) {
            super(model);
            this.referenceStoreId(model.referenceStoreId);
            this.roleArn(model.roleArn);
            this.clientToken(model.clientToken);
            this.sources(model.sources);
        }

        public final String getReferenceStoreId() {
            return this.referenceStoreId;
        }

        public final void setReferenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
        }

        @Override
        public final Builder referenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<StartReferenceImportJobSourceItem.Builder> getSources() {
            List<StartReferenceImportJobSourceItem.Builder> result = StartReferenceImportJobRequestSourcesListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<StartReferenceImportJobSourceItem.BuilderImpl> sources) {
            this.sources = StartReferenceImportJobRequestSourcesListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<StartReferenceImportJobSourceItem> sources) {
            this.sources = StartReferenceImportJobRequestSourcesListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(StartReferenceImportJobSourceItem ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<StartReferenceImportJobSourceItem.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (StartReferenceImportJobSourceItem)((StartReferenceImportJobSourceItem.Builder)StartReferenceImportJobSourceItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReferenceImportJobRequest build() {
            return new StartReferenceImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartReferenceImportJobRequest> {
        public Builder referenceStoreId(String var1);

        public Builder roleArn(String var1);

        public Builder clientToken(String var1);

        public Builder sources(Collection<StartReferenceImportJobSourceItem> var1);

        public Builder sources(StartReferenceImportJobSourceItem ... var1);

        public Builder sources(Consumer<StartReferenceImportJobSourceItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

