/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequestSourcesListCopier;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobSourceItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartReadSetImportJobRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, StartReadSetImportJobRequest> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(StartReadSetImportJobRequest.getter(StartReadSetImportJobRequest::sequenceStoreId)).setter(StartReadSetImportJobRequest.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StartReadSetImportJobRequest.getter(StartReadSetImportJobRequest::roleArn)).setter(StartReadSetImportJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(StartReadSetImportJobRequest.getter(StartReadSetImportJobRequest::clientToken)).setter(StartReadSetImportJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<List<StartReadSetImportJobSourceItem>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(StartReadSetImportJobRequest.getter(StartReadSetImportJobRequest::sources)).setter(StartReadSetImportJobRequest.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StartReadSetImportJobSourceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, SOURCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
            this.put("roleArn", ROLE_ARN_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("sources", SOURCES_FIELD);
        }
    });
    private final String sequenceStoreId;
    private final String roleArn;
    private final String clientToken;
    private final List<StartReadSetImportJobSourceItem> sources;

    private StartReadSetImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
        this.sources = builder.sources;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<StartReadSetImportJobSourceItem> sources() {
        return this.sources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReadSetImportJobRequest)) {
            return false;
        }
        StartReadSetImportJobRequest other = (StartReadSetImportJobRequest)((Object)obj);
        return Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources());
    }

    public final String toString() {
        return ToString.builder((String)"StartReadSetImportJobRequest").add("SequenceStoreId", (Object)this.sequenceStoreId()).add("RoleArn", (Object)this.roleArn()).add("ClientToken", (Object)this.clientToken()).add("Sources", this.hasSources() ? this.sources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartReadSetImportJobRequest, T> g) {
        return obj -> g.apply((StartReadSetImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String sequenceStoreId;
        private String roleArn;
        private String clientToken;
        private List<StartReadSetImportJobSourceItem> sources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartReadSetImportJobRequest model) {
            super(model);
            this.sequenceStoreId(model.sequenceStoreId);
            this.roleArn(model.roleArn);
            this.clientToken(model.clientToken);
            this.sources(model.sources);
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<StartReadSetImportJobSourceItem.Builder> getSources() {
            List<StartReadSetImportJobSourceItem.Builder> result = StartReadSetImportJobRequestSourcesListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<StartReadSetImportJobSourceItem.BuilderImpl> sources) {
            this.sources = StartReadSetImportJobRequestSourcesListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<StartReadSetImportJobSourceItem> sources) {
            this.sources = StartReadSetImportJobRequestSourcesListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(StartReadSetImportJobSourceItem ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<StartReadSetImportJobSourceItem.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (StartReadSetImportJobSourceItem)((StartReadSetImportJobSourceItem.Builder)StartReadSetImportJobSourceItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartReadSetImportJobRequest build() {
            return new StartReadSetImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartReadSetImportJobRequest> {
        public Builder sequenceStoreId(String var1);

        public Builder roleArn(String var1);

        public Builder clientToken(String var1);

        public Builder sources(Collection<StartReadSetImportJobSourceItem> var1);

        public Builder sources(StartReadSetImportJobSourceItem ... var1);

        public Builder sources(Consumer<StartReadSetImportJobSourceItem.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

