/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ShareDetails;
import software.amazon.awssdk.services.omics.model.ShareDetailsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSharesResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListSharesResponse> {
    private static final SdkField<List<ShareDetails>> SHARES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("shares").getter(ListSharesResponse.getter(ListSharesResponse::shares)).setter(ListSharesResponse.setter(Builder::shares)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shares").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ShareDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSharesResponse.getter(ListSharesResponse::nextToken)).setter(ListSharesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("shares", SHARES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<ShareDetails> shares;
    private final String nextToken;

    private ListSharesResponse(BuilderImpl builder) {
        super(builder);
        this.shares = builder.shares;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasShares() {
        return this.shares != null && !(this.shares instanceof SdkAutoConstructList);
    }

    public final List<ShareDetails> shares() {
        return this.shares;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShares() ? this.shares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSharesResponse)) {
            return false;
        }
        ListSharesResponse other = (ListSharesResponse)((Object)obj);
        return this.hasShares() == other.hasShares() && Objects.equals(this.shares(), other.shares()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSharesResponse").add("Shares", this.hasShares() ? this.shares() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "shares": {
                return Optional.ofNullable(clazz.cast(this.shares()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSharesResponse, T> g) {
        return obj -> g.apply((ListSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private List<ShareDetails> shares = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSharesResponse model) {
            super(model);
            this.shares(model.shares);
            this.nextToken(model.nextToken);
        }

        public final List<ShareDetails.Builder> getShares() {
            List<ShareDetails.Builder> result = ShareDetailsListCopier.copyToBuilder(this.shares);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShares(Collection<ShareDetails.BuilderImpl> shares) {
            this.shares = ShareDetailsListCopier.copyFromBuilder(shares);
        }

        @Override
        public final Builder shares(Collection<ShareDetails> shares) {
            this.shares = ShareDetailsListCopier.copy(shares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shares(ShareDetails ... shares) {
            this.shares(Arrays.asList(shares));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shares(Consumer<ShareDetails.Builder> ... shares) {
            this.shares(Stream.of(shares).map(c -> (ShareDetails)((ShareDetails.Builder)ShareDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSharesResponse build() {
            return new ListSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSharesResponse> {
        public Builder shares(Collection<ShareDetails> var1);

        public Builder shares(ShareDetails ... var1);

        public Builder shares(Consumer<ShareDetails.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

