/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReadSetListCopier;
import software.amazon.awssdk.services.omics.model.ReadSetListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListReadSetsResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListReadSetsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListReadSetsResponse.getter(ListReadSetsResponse::nextToken)).setter(ListReadSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ReadSetListItem>> READ_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("readSets").getter(ListReadSetsResponse.getter(ListReadSetsResponse::readSets)).setter(ListReadSetsResponse.setter(Builder::readSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReadSetListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, READ_SETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("readSets", READ_SETS_FIELD);
        }
    });
    private final String nextToken;
    private final List<ReadSetListItem> readSets;

    private ListReadSetsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.readSets = builder.readSets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReadSets() {
        return this.readSets != null && !(this.readSets instanceof SdkAutoConstructList);
    }

    public final List<ReadSetListItem> readSets() {
        return this.readSets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReadSets() ? this.readSets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReadSetsResponse)) {
            return false;
        }
        ListReadSetsResponse other = (ListReadSetsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReadSets() == other.hasReadSets() && Objects.equals(this.readSets(), other.readSets());
    }

    public final String toString() {
        return ToString.builder((String)"ListReadSetsResponse").add("NextToken", (Object)this.nextToken()).add("ReadSets", this.hasReadSets() ? this.readSets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "readSets": {
                return Optional.ofNullable(clazz.cast(this.readSets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListReadSetsResponse, T> g) {
        return obj -> g.apply((ListReadSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReadSetListItem> readSets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListReadSetsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.readSets(model.readSets);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReadSetListItem.Builder> getReadSets() {
            List<ReadSetListItem.Builder> result = ReadSetListCopier.copyToBuilder(this.readSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReadSets(Collection<ReadSetListItem.BuilderImpl> readSets) {
            this.readSets = ReadSetListCopier.copyFromBuilder(readSets);
        }

        @Override
        public final Builder readSets(Collection<ReadSetListItem> readSets) {
            this.readSets = ReadSetListCopier.copy(readSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readSets(ReadSetListItem ... readSets) {
            this.readSets(Arrays.asList(readSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readSets(Consumer<ReadSetListItem.Builder> ... readSets) {
            this.readSets(Stream.of(readSets).map(c -> (ReadSetListItem)((ReadSetListItem.Builder)ReadSetListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListReadSetsResponse build() {
            return new ListReadSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListReadSetsResponse> {
        public Builder nextToken(String var1);

        public Builder readSets(Collection<ReadSetListItem> var1);

        public Builder readSets(ReadSetListItem ... var1);

        public Builder readSets(Consumer<ReadSetListItem.Builder> ... var1);
    }
}

