/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReferenceCreationType;
import software.amazon.awssdk.services.omics.model.ReferenceFiles;
import software.amazon.awssdk.services.omics.model.ReferenceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReferenceMetadataResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetReferenceMetadataResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::id)).setter(GetReferenceMetadataResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::arn)).setter(GetReferenceMetadataResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> REFERENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceStoreId").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::referenceStoreId)).setter(GetReferenceMetadataResponse.setter(Builder::referenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceStoreId").build()}).build();
    private static final SdkField<String> MD5_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("md5").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::md5)).setter(GetReferenceMetadataResponse.setter(Builder::md5)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("md5").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::statusAsString)).setter(GetReferenceMetadataResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::name)).setter(GetReferenceMetadataResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::description)).setter(GetReferenceMetadataResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::creationTime)).setter(GetReferenceMetadataResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::updateTime)).setter(GetReferenceMetadataResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ReferenceFiles> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("files").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::files)).setter(GetReferenceMetadataResponse.setter(Builder::files)).constructor(ReferenceFiles::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build()}).build();
    private static final SdkField<String> CREATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationType").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::creationTypeAsString)).setter(GetReferenceMetadataResponse.setter(Builder::creationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationType").build()}).build();
    private static final SdkField<String> CREATION_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationJobId").getter(GetReferenceMetadataResponse.getter(GetReferenceMetadataResponse::creationJobId)).setter(GetReferenceMetadataResponse.setter(Builder::creationJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationJobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, REFERENCE_STORE_ID_FIELD, MD5_FIELD, STATUS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, UPDATE_TIME_FIELD, FILES_FIELD, CREATION_TYPE_FIELD, CREATION_JOB_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("id", ID_FIELD);
            this.put("arn", ARN_FIELD);
            this.put("referenceStoreId", REFERENCE_STORE_ID_FIELD);
            this.put("md5", MD5_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("updateTime", UPDATE_TIME_FIELD);
            this.put("files", FILES_FIELD);
            this.put("creationType", CREATION_TYPE_FIELD);
            this.put("creationJobId", CREATION_JOB_ID_FIELD);
        }
    });
    private final String id;
    private final String arn;
    private final String referenceStoreId;
    private final String md5;
    private final String status;
    private final String name;
    private final String description;
    private final Instant creationTime;
    private final Instant updateTime;
    private final ReferenceFiles files;
    private final String creationType;
    private final String creationJobId;

    private GetReferenceMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.referenceStoreId = builder.referenceStoreId;
        this.md5 = builder.md5;
        this.status = builder.status;
        this.name = builder.name;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
        this.files = builder.files;
        this.creationType = builder.creationType;
        this.creationJobId = builder.creationJobId;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String referenceStoreId() {
        return this.referenceStoreId;
    }

    public final String md5() {
        return this.md5;
    }

    public final ReferenceStatus status() {
        return ReferenceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public final ReferenceFiles files() {
        return this.files;
    }

    public final ReferenceCreationType creationType() {
        return ReferenceCreationType.fromValue(this.creationType);
    }

    public final String creationTypeAsString() {
        return this.creationType;
    }

    public final String creationJobId() {
        return this.creationJobId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.md5());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.files());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationJobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReferenceMetadataResponse)) {
            return false;
        }
        GetReferenceMetadataResponse other = (GetReferenceMetadataResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.referenceStoreId(), other.referenceStoreId()) && Objects.equals(this.md5(), other.md5()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.updateTime(), other.updateTime()) && Objects.equals(this.files(), other.files()) && Objects.equals(this.creationTypeAsString(), other.creationTypeAsString()) && Objects.equals(this.creationJobId(), other.creationJobId());
    }

    public final String toString() {
        return ToString.builder((String)"GetReferenceMetadataResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("ReferenceStoreId", (Object)this.referenceStoreId()).add("Md5", (Object)this.md5()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).add("UpdateTime", (Object)this.updateTime()).add("Files", (Object)this.files()).add("CreationType", (Object)this.creationTypeAsString()).add("CreationJobId", (Object)this.creationJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "referenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.referenceStoreId()));
            }
            case "md5": {
                return Optional.ofNullable(clazz.cast(this.md5()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "creationType": {
                return Optional.ofNullable(clazz.cast(this.creationTypeAsString()));
            }
            case "creationJobId": {
                return Optional.ofNullable(clazz.cast(this.creationJobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetReferenceMetadataResponse, T> g) {
        return obj -> g.apply((GetReferenceMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String referenceStoreId;
        private String md5;
        private String status;
        private String name;
        private String description;
        private Instant creationTime;
        private Instant updateTime;
        private ReferenceFiles files;
        private String creationType;
        private String creationJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReferenceMetadataResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.referenceStoreId(model.referenceStoreId);
            this.md5(model.md5);
            this.status(model.status);
            this.name(model.name);
            this.description(model.description);
            this.creationTime(model.creationTime);
            this.updateTime(model.updateTime);
            this.files(model.files);
            this.creationType(model.creationType);
            this.creationJobId(model.creationJobId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getReferenceStoreId() {
            return this.referenceStoreId;
        }

        public final void setReferenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
        }

        @Override
        public final Builder referenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
            return this;
        }

        public final String getMd5() {
            return this.md5;
        }

        public final void setMd5(String md5) {
            this.md5 = md5;
        }

        @Override
        public final Builder md5(String md5) {
            this.md5 = md5;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReferenceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final ReferenceFiles.Builder getFiles() {
            return this.files != null ? this.files.toBuilder() : null;
        }

        public final void setFiles(ReferenceFiles.BuilderImpl files) {
            this.files = files != null ? files.build() : null;
        }

        @Override
        public final Builder files(ReferenceFiles files) {
            this.files = files;
            return this;
        }

        public final String getCreationType() {
            return this.creationType;
        }

        public final void setCreationType(String creationType) {
            this.creationType = creationType;
        }

        @Override
        public final Builder creationType(String creationType) {
            this.creationType = creationType;
            return this;
        }

        @Override
        public final Builder creationType(ReferenceCreationType creationType) {
            this.creationType(creationType == null ? null : creationType.toString());
            return this;
        }

        public final String getCreationJobId() {
            return this.creationJobId;
        }

        public final void setCreationJobId(String creationJobId) {
            this.creationJobId = creationJobId;
        }

        @Override
        public final Builder creationJobId(String creationJobId) {
            this.creationJobId = creationJobId;
            return this;
        }

        @Override
        public GetReferenceMetadataResponse build() {
            return new GetReferenceMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReferenceMetadataResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder referenceStoreId(String var1);

        public Builder md5(String var1);

        public Builder status(String var1);

        public Builder status(ReferenceStatus var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder creationTime(Instant var1);

        public Builder updateTime(Instant var1);

        public Builder files(ReferenceFiles var1);

        default public Builder files(Consumer<ReferenceFiles.Builder> files) {
            return this.files((ReferenceFiles)((ReferenceFiles.Builder)ReferenceFiles.builder().applyMutation(files)).build());
        }

        public Builder creationType(String var1);

        public Builder creationType(ReferenceCreationType var1);

        public Builder creationJobId(String var1);
    }
}

