/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ETagAlgorithmFamily {
    MD5_UP("MD5up"),
    SHA256_UP("SHA256up"),
    SHA512_UP("SHA512up"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ETagAlgorithmFamily> VALUE_MAP;
    private final String value;

    private ETagAlgorithmFamily(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ETagAlgorithmFamily fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ETagAlgorithmFamily> knownValues() {
        EnumSet<ETagAlgorithmFamily> knownValues = EnumSet.allOf(ETagAlgorithmFamily.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ETagAlgorithmFamily.class, ETagAlgorithmFamily::toString);
    }
}

