/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyAlias;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCoreNetworkPolicyRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, GetCoreNetworkPolicyRequest> {
    private static final SdkField<String> CORE_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CoreNetworkId").getter(GetCoreNetworkPolicyRequest.getter(GetCoreNetworkPolicyRequest::coreNetworkId)).setter(GetCoreNetworkPolicyRequest.setter(Builder::coreNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("coreNetworkId").build()}).build();
    private static final SdkField<Integer> POLICY_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PolicyVersionId").getter(GetCoreNetworkPolicyRequest.getter(GetCoreNetworkPolicyRequest::policyVersionId)).setter(GetCoreNetworkPolicyRequest.setter(Builder::policyVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("policyVersionId").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Alias").getter(GetCoreNetworkPolicyRequest.getter(GetCoreNetworkPolicyRequest::aliasAsString)).setter(GetCoreNetworkPolicyRequest.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("alias").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CORE_NETWORK_ID_FIELD, POLICY_VERSION_ID_FIELD, ALIAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("coreNetworkId", CORE_NETWORK_ID_FIELD);
            this.put("policyVersionId", POLICY_VERSION_ID_FIELD);
            this.put("alias", ALIAS_FIELD);
        }
    });
    private final String coreNetworkId;
    private final Integer policyVersionId;
    private final String alias;

    private GetCoreNetworkPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.coreNetworkId = builder.coreNetworkId;
        this.policyVersionId = builder.policyVersionId;
        this.alias = builder.alias;
    }

    public final String coreNetworkId() {
        return this.coreNetworkId;
    }

    public final Integer policyVersionId() {
        return this.policyVersionId;
    }

    public final CoreNetworkPolicyAlias alias() {
        return CoreNetworkPolicyAlias.fromValue(this.alias);
    }

    public final String aliasAsString() {
        return this.alias;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.coreNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCoreNetworkPolicyRequest)) {
            return false;
        }
        GetCoreNetworkPolicyRequest other = (GetCoreNetworkPolicyRequest)((Object)obj);
        return Objects.equals(this.coreNetworkId(), other.coreNetworkId()) && Objects.equals(this.policyVersionId(), other.policyVersionId()) && Objects.equals(this.aliasAsString(), other.aliasAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetCoreNetworkPolicyRequest").add("CoreNetworkId", (Object)this.coreNetworkId()).add("PolicyVersionId", (Object)this.policyVersionId()).add("Alias", (Object)this.aliasAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CoreNetworkId": {
                return Optional.ofNullable(clazz.cast(this.coreNetworkId()));
            }
            case "PolicyVersionId": {
                return Optional.ofNullable(clazz.cast(this.policyVersionId()));
            }
            case "Alias": {
                return Optional.ofNullable(clazz.cast(this.aliasAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCoreNetworkPolicyRequest, T> g) {
        return obj -> g.apply((GetCoreNetworkPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String coreNetworkId;
        private Integer policyVersionId;
        private String alias;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCoreNetworkPolicyRequest model) {
            super(model);
            this.coreNetworkId(model.coreNetworkId);
            this.policyVersionId(model.policyVersionId);
            this.alias(model.alias);
        }

        public final String getCoreNetworkId() {
            return this.coreNetworkId;
        }

        public final void setCoreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
        }

        @Override
        public final Builder coreNetworkId(String coreNetworkId) {
            this.coreNetworkId = coreNetworkId;
            return this;
        }

        public final Integer getPolicyVersionId() {
            return this.policyVersionId;
        }

        public final void setPolicyVersionId(Integer policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        public final Builder policyVersionId(Integer policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        @Override
        public final Builder alias(CoreNetworkPolicyAlias alias) {
            this.alias(alias == null ? null : alias.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCoreNetworkPolicyRequest build() {
            return new GetCoreNetworkPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCoreNetworkPolicyRequest> {
        public Builder coreNetworkId(String var1);

        public Builder policyVersionId(Integer var1);

        public Builder alias(String var1);

        public Builder alias(CoreNetworkPolicyAlias var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

