/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.networkfirewall.model.IPSetReference;
import software.amazon.awssdk.services.networkfirewall.model.IPSetReferenceMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReferenceSets
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReferenceSets> {
    private static final SdkField<Map<String, IPSetReference>> IP_SET_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("IPSetReferences").getter(ReferenceSets.getter(ReferenceSets::ipSetReferences)).setter(ReferenceSets.setter(Builder::ipSetReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPSetReferences").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IPSetReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_SET_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IPSetReferences", IP_SET_REFERENCES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, IPSetReference> ipSetReferences;

    private ReferenceSets(BuilderImpl builder) {
        this.ipSetReferences = builder.ipSetReferences;
    }

    public final boolean hasIpSetReferences() {
        return this.ipSetReferences != null && !(this.ipSetReferences instanceof SdkAutoConstructMap);
    }

    public final Map<String, IPSetReference> ipSetReferences() {
        return this.ipSetReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpSetReferences() ? this.ipSetReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReferenceSets)) {
            return false;
        }
        ReferenceSets other = (ReferenceSets)obj;
        return this.hasIpSetReferences() == other.hasIpSetReferences() && Objects.equals(this.ipSetReferences(), other.ipSetReferences());
    }

    public final String toString() {
        return ToString.builder((String)"ReferenceSets").add("IPSetReferences", this.hasIpSetReferences() ? this.ipSetReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IPSetReferences": {
                return Optional.ofNullable(clazz.cast(this.ipSetReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReferenceSets, T> g) {
        return obj -> g.apply((ReferenceSets)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, IPSetReference> ipSetReferences = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReferenceSets model) {
            this.ipSetReferences(model.ipSetReferences);
        }

        public final Map<String, IPSetReference.Builder> getIpSetReferences() {
            Map<String, IPSetReference.Builder> result = IPSetReferenceMapCopier.copyToBuilder(this.ipSetReferences);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setIpSetReferences(Map<String, IPSetReference.BuilderImpl> ipSetReferences) {
            this.ipSetReferences = IPSetReferenceMapCopier.copyFromBuilder(ipSetReferences);
        }

        @Override
        public final Builder ipSetReferences(Map<String, IPSetReference> ipSetReferences) {
            this.ipSetReferences = IPSetReferenceMapCopier.copy(ipSetReferences);
            return this;
        }

        public ReferenceSets build() {
            return new ReferenceSets(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReferenceSets> {
        public Builder ipSetReferences(Map<String, IPSetReference> var1);
    }
}

