/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkfirewall.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkfirewall.model.StatefulRuleDirection;
import software.amazon.awssdk.services.networkfirewall.model.StatefulRuleProtocol;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Header
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Header> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Protocol").getter(Header.getter(Header::protocolAsString)).setter(Header.setter(Builder::protocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(Header.getter(Header::source)).setter(Header.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> SOURCE_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourcePort").getter(Header.getter(Header::sourcePort)).setter(Header.setter(Builder::sourcePort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourcePort").build()}).build();
    private static final SdkField<String> DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Direction").getter(Header.getter(Header::directionAsString)).setter(Header.setter(Builder::direction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Direction").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Destination").getter(Header.getter(Header::destination)).setter(Header.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Destination").build()}).build();
    private static final SdkField<String> DESTINATION_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationPort").getter(Header.getter(Header::destinationPort)).setter(Header.setter(Builder::destinationPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationPort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD, SOURCE_FIELD, SOURCE_PORT_FIELD, DIRECTION_FIELD, DESTINATION_FIELD, DESTINATION_PORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Protocol", PROTOCOL_FIELD);
            this.put("Source", SOURCE_FIELD);
            this.put("SourcePort", SOURCE_PORT_FIELD);
            this.put("Direction", DIRECTION_FIELD);
            this.put("Destination", DESTINATION_FIELD);
            this.put("DestinationPort", DESTINATION_PORT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String protocol;
    private final String source;
    private final String sourcePort;
    private final String direction;
    private final String destination;
    private final String destinationPort;

    private Header(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.source = builder.source;
        this.sourcePort = builder.sourcePort;
        this.direction = builder.direction;
        this.destination = builder.destination;
        this.destinationPort = builder.destinationPort;
    }

    public final StatefulRuleProtocol protocol() {
        return StatefulRuleProtocol.fromValue(this.protocol);
    }

    public final String protocolAsString() {
        return this.protocol;
    }

    public final String source() {
        return this.source;
    }

    public final String sourcePort() {
        return this.sourcePort;
    }

    public final StatefulRuleDirection direction() {
        return StatefulRuleDirection.fromValue(this.direction);
    }

    public final String directionAsString() {
        return this.direction;
    }

    public final String destination() {
        return this.destination;
    }

    public final String destinationPort() {
        return this.destinationPort;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePort());
        hashCode = 31 * hashCode + Objects.hashCode(this.directionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationPort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Header)) {
            return false;
        }
        Header other = (Header)obj;
        return Objects.equals(this.protocolAsString(), other.protocolAsString()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.sourcePort(), other.sourcePort()) && Objects.equals(this.directionAsString(), other.directionAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationPort(), other.destinationPort());
    }

    public final String toString() {
        return ToString.builder((String)"Header").add("Protocol", (Object)this.protocolAsString()).add("Source", (Object)this.source()).add("SourcePort", (Object)this.sourcePort()).add("Direction", (Object)this.directionAsString()).add("Destination", (Object)this.destination()).add("DestinationPort", (Object)this.destinationPort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Protocol": {
                return Optional.ofNullable(clazz.cast(this.protocolAsString()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "SourcePort": {
                return Optional.ofNullable(clazz.cast(this.sourcePort()));
            }
            case "Direction": {
                return Optional.ofNullable(clazz.cast(this.directionAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationPort": {
                return Optional.ofNullable(clazz.cast(this.destinationPort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Header, T> g) {
        return obj -> g.apply((Header)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String protocol;
        private String source;
        private String sourcePort;
        private String direction;
        private String destination;
        private String destinationPort;

        private BuilderImpl() {
        }

        private BuilderImpl(Header model) {
            this.protocol(model.protocol);
            this.source(model.source);
            this.sourcePort(model.sourcePort);
            this.direction(model.direction);
            this.destination(model.destination);
            this.destinationPort(model.destinationPort);
        }

        public final String getProtocol() {
            return this.protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(StatefulRuleProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getSourcePort() {
            return this.sourcePort;
        }

        public final void setSourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
        }

        @Override
        public final Builder sourcePort(String sourcePort) {
            this.sourcePort = sourcePort;
            return this;
        }

        public final String getDirection() {
            return this.direction;
        }

        public final void setDirection(String direction) {
            this.direction = direction;
        }

        @Override
        public final Builder direction(String direction) {
            this.direction = direction;
            return this;
        }

        @Override
        public final Builder direction(StatefulRuleDirection direction) {
            this.direction(direction == null ? null : direction.toString());
            return this;
        }

        public final String getDestination() {
            return this.destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getDestinationPort() {
            return this.destinationPort;
        }

        public final void setDestinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
        }

        @Override
        public final Builder destinationPort(String destinationPort) {
            this.destinationPort = destinationPort;
            return this;
        }

        public Header build() {
            return new Header(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Header> {
        public Builder protocol(String var1);

        public Builder protocol(StatefulRuleProtocol var1);

        public Builder source(String var1);

        public Builder sourcePort(String var1);

        public Builder direction(String var1);

        public Builder direction(StatefulRuleDirection var1);

        public Builder destination(String var1);

        public Builder destinationPort(String var1);
    }
}

