/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataResponse;
import software.amazon.awssdk.services.neptunedata.model.SparqlRecord;
import software.amazon.awssdk.services.neptunedata.model.SparqlRecordsListCopier;
import software.amazon.awssdk.services.neptunedata.model.StringValuedMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSparqlStreamResponse
extends NeptunedataResponse
implements ToCopyableBuilder<Builder, GetSparqlStreamResponse> {
    private static final SdkField<Map<String, String>> LAST_EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("lastEventId").getter(GetSparqlStreamResponse.getter(GetSparqlStreamResponse::lastEventId)).setter(GetSparqlStreamResponse.setter(Builder::lastEventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastEventId").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Long> LAST_TRX_TIMESTAMP_IN_MILLIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastTrxTimestampInMillis").getter(GetSparqlStreamResponse.getter(GetSparqlStreamResponse::lastTrxTimestampInMillis)).setter(GetSparqlStreamResponse.setter(Builder::lastTrxTimestampInMillis)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastTrxTimestamp").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(GetSparqlStreamResponse.getter(GetSparqlStreamResponse::format)).setter(GetSparqlStreamResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<List<SparqlRecord>> RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("records").getter(GetSparqlStreamResponse.getter(GetSparqlStreamResponse::records)).setter(GetSparqlStreamResponse.setter(Builder::records)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SparqlRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalRecords").getter(GetSparqlStreamResponse.getter(GetSparqlStreamResponse::totalRecords)).setter(GetSparqlStreamResponse.setter(Builder::totalRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalRecords").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_EVENT_ID_FIELD, LAST_TRX_TIMESTAMP_IN_MILLIS_FIELD, FORMAT_FIELD, RECORDS_FIELD, TOTAL_RECORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("lastEventId", LAST_EVENT_ID_FIELD);
            this.put("lastTrxTimestamp", LAST_TRX_TIMESTAMP_IN_MILLIS_FIELD);
            this.put("format", FORMAT_FIELD);
            this.put("records", RECORDS_FIELD);
            this.put("totalRecords", TOTAL_RECORDS_FIELD);
        }
    });
    private final Map<String, String> lastEventId;
    private final Long lastTrxTimestampInMillis;
    private final String format;
    private final List<SparqlRecord> records;
    private final Integer totalRecords;

    private GetSparqlStreamResponse(BuilderImpl builder) {
        super(builder);
        this.lastEventId = builder.lastEventId;
        this.lastTrxTimestampInMillis = builder.lastTrxTimestampInMillis;
        this.format = builder.format;
        this.records = builder.records;
        this.totalRecords = builder.totalRecords;
    }

    public final boolean hasLastEventId() {
        return this.lastEventId != null && !(this.lastEventId instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> lastEventId() {
        return this.lastEventId;
    }

    public final Long lastTrxTimestampInMillis() {
        return this.lastTrxTimestampInMillis;
    }

    public final String format() {
        return this.format;
    }

    public final boolean hasRecords() {
        return this.records != null && !(this.records instanceof SdkAutoConstructList);
    }

    public final List<SparqlRecord> records() {
        return this.records;
    }

    public final Integer totalRecords() {
        return this.totalRecords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLastEventId() ? this.lastEventId() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastTrxTimestampInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.format());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecords() ? this.records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRecords());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSparqlStreamResponse)) {
            return false;
        }
        GetSparqlStreamResponse other = (GetSparqlStreamResponse)((Object)obj);
        return this.hasLastEventId() == other.hasLastEventId() && Objects.equals(this.lastEventId(), other.lastEventId()) && Objects.equals(this.lastTrxTimestampInMillis(), other.lastTrxTimestampInMillis()) && Objects.equals(this.format(), other.format()) && this.hasRecords() == other.hasRecords() && Objects.equals(this.records(), other.records()) && Objects.equals(this.totalRecords(), other.totalRecords());
    }

    public final String toString() {
        return ToString.builder((String)"GetSparqlStreamResponse").add("LastEventId", this.hasLastEventId() ? this.lastEventId() : null).add("LastTrxTimestampInMillis", (Object)this.lastTrxTimestampInMillis()).add("Format", (Object)this.format()).add("Records", this.hasRecords() ? this.records() : null).add("TotalRecords", (Object)this.totalRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lastEventId": {
                return Optional.ofNullable(clazz.cast(this.lastEventId()));
            }
            case "lastTrxTimestampInMillis": {
                return Optional.ofNullable(clazz.cast(this.lastTrxTimestampInMillis()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.format()));
            }
            case "records": {
                return Optional.ofNullable(clazz.cast(this.records()));
            }
            case "totalRecords": {
                return Optional.ofNullable(clazz.cast(this.totalRecords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetSparqlStreamResponse, T> g) {
        return obj -> g.apply((GetSparqlStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataResponse.BuilderImpl
    implements Builder {
        private Map<String, String> lastEventId = DefaultSdkAutoConstructMap.getInstance();
        private Long lastTrxTimestampInMillis;
        private String format;
        private List<SparqlRecord> records = DefaultSdkAutoConstructList.getInstance();
        private Integer totalRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSparqlStreamResponse model) {
            super(model);
            this.lastEventId(model.lastEventId);
            this.lastTrxTimestampInMillis(model.lastTrxTimestampInMillis);
            this.format(model.format);
            this.records(model.records);
            this.totalRecords(model.totalRecords);
        }

        public final Map<String, String> getLastEventId() {
            if (this.lastEventId instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.lastEventId;
        }

        public final void setLastEventId(Map<String, String> lastEventId) {
            this.lastEventId = StringValuedMapCopier.copy(lastEventId);
        }

        @Override
        public final Builder lastEventId(Map<String, String> lastEventId) {
            this.lastEventId = StringValuedMapCopier.copy(lastEventId);
            return this;
        }

        public final Long getLastTrxTimestampInMillis() {
            return this.lastTrxTimestampInMillis;
        }

        public final void setLastTrxTimestampInMillis(Long lastTrxTimestampInMillis) {
            this.lastTrxTimestampInMillis = lastTrxTimestampInMillis;
        }

        @Override
        public final Builder lastTrxTimestampInMillis(Long lastTrxTimestampInMillis) {
            this.lastTrxTimestampInMillis = lastTrxTimestampInMillis;
            return this;
        }

        public final String getFormat() {
            return this.format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        public final List<SparqlRecord.Builder> getRecords() {
            List<SparqlRecord.Builder> result = SparqlRecordsListCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<SparqlRecord.BuilderImpl> records) {
            this.records = SparqlRecordsListCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<SparqlRecord> records) {
            this.records = SparqlRecordsListCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(SparqlRecord ... records) {
            this.records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<SparqlRecord.Builder> ... records) {
            this.records(Stream.of(records).map(c -> (SparqlRecord)((SparqlRecord.Builder)SparqlRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalRecords() {
            return this.totalRecords;
        }

        public final void setTotalRecords(Integer totalRecords) {
            this.totalRecords = totalRecords;
        }

        @Override
        public final Builder totalRecords(Integer totalRecords) {
            this.totalRecords = totalRecords;
            return this;
        }

        @Override
        public GetSparqlStreamResponse build() {
            return new GetSparqlStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSparqlStreamResponse> {
        public Builder lastEventId(Map<String, String> var1);

        public Builder lastTrxTimestampInMillis(Long var1);

        public Builder format(String var1);

        public Builder records(Collection<SparqlRecord> var1);

        public Builder records(SparqlRecord ... var1);

        public Builder records(Consumer<SparqlRecord.Builder> ... var1);

        public Builder totalRecords(Integer var1);
    }
}

