/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Locale
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Locale> {
    private static final SdkField<String> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Country").getter(Locale.getter(Locale::country)).setter(Locale.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<String> SUBDIVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Subdivision").getter(Locale.getter(Locale::subdivision)).setter(Locale.setter(Builder::subdivision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subdivision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, SUBDIVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Country", COUNTRY_FIELD);
            this.put("Subdivision", SUBDIVISION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String country;
    private final String subdivision;

    private Locale(BuilderImpl builder) {
        this.country = builder.country;
        this.subdivision = builder.subdivision;
    }

    public final String country() {
        return this.country;
    }

    public final String subdivision() {
        return this.subdivision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.subdivision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Locale)) {
            return false;
        }
        Locale other = (Locale)obj;
        return Objects.equals(this.country(), other.country()) && Objects.equals(this.subdivision(), other.subdivision());
    }

    public final String toString() {
        return ToString.builder((String)"Locale").add("Country", (Object)this.country()).add("Subdivision", (Object)this.subdivision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Subdivision": {
                return Optional.ofNullable(clazz.cast(this.subdivision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Locale, T> g) {
        return obj -> g.apply((Locale)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String country;
        private String subdivision;

        private BuilderImpl() {
        }

        private BuilderImpl(Locale model) {
            this.country(model.country);
            this.subdivision(model.subdivision);
        }

        public final String getCountry() {
            return this.country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getSubdivision() {
            return this.subdivision;
        }

        public final void setSubdivision(String subdivision) {
            this.subdivision = subdivision;
        }

        @Override
        public final Builder subdivision(String subdivision) {
            this.subdivision = subdivision;
            return this;
        }

        public Locale build() {
            return new Locale(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Locale> {
        public Builder country(String var1);

        public Builder subdivision(String var1);
    }
}

