/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mq.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerInstance> {
    private static final SdkField<String> CONSOLE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsoleURL").getter(BrokerInstance.getter(BrokerInstance::consoleURL)).setter(BrokerInstance.setter(Builder::consoleURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consoleURL").build()}).build();
    private static final SdkField<List<String>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(BrokerInstance.getter(BrokerInstance::endpoints)).setter(BrokerInstance.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(BrokerInstance.getter(BrokerInstance::ipAddress)).setter(BrokerInstance.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSOLE_URL_FIELD, ENDPOINTS_FIELD, IP_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("consoleURL", CONSOLE_URL_FIELD);
            this.put("endpoints", ENDPOINTS_FIELD);
            this.put("ipAddress", IP_ADDRESS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String consoleURL;
    private final List<String> endpoints;
    private final String ipAddress;

    private BrokerInstance(BuilderImpl builder) {
        this.consoleURL = builder.consoleURL;
        this.endpoints = builder.endpoints;
        this.ipAddress = builder.ipAddress;
    }

    public final String consoleURL() {
        return this.consoleURL;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<String> endpoints() {
        return this.endpoints;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.consoleURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerInstance)) {
            return false;
        }
        BrokerInstance other = (BrokerInstance)obj;
        return Objects.equals(this.consoleURL(), other.consoleURL()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints()) && Objects.equals(this.ipAddress(), other.ipAddress());
    }

    public final String toString() {
        return ToString.builder((String)"BrokerInstance").add("ConsoleURL", (Object)this.consoleURL()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).add("IpAddress", (Object)this.ipAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsoleURL": {
                return Optional.ofNullable(clazz.cast(this.consoleURL()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BrokerInstance, T> g) {
        return obj -> g.apply((BrokerInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String consoleURL;
        private List<String> endpoints = DefaultSdkAutoConstructList.getInstance();
        private String ipAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerInstance model) {
            this.consoleURL(model.consoleURL);
            this.endpoints(model.endpoints);
            this.ipAddress(model.ipAddress);
        }

        public final String getConsoleURL() {
            return this.consoleURL;
        }

        public final void setConsoleURL(String consoleURL) {
            this.consoleURL = consoleURL;
        }

        @Override
        public final Builder consoleURL(String consoleURL) {
            this.consoleURL = consoleURL;
            return this;
        }

        public final Collection<String> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpoints;
        }

        public final void setEndpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(String ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public BrokerInstance build() {
            return new BrokerInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerInstance> {
        public Builder consoleURL(String var1);

        public Builder endpoints(Collection<String> var1);

        public Builder endpoints(String ... var1);

        public Builder ipAddress(String var1);
    }
}

