/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.Group;
import software.amazon.awssdk.services.migrationhubstrategy.model.GroupIdsCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.OutputFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartRecommendationReportGenerationRequest
extends MigrationHubStrategyRequest
implements ToCopyableBuilder<Builder, StartRecommendationReportGenerationRequest> {
    private static final SdkField<List<Group>> GROUP_ID_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupIdFilter").getter(StartRecommendationReportGenerationRequest.getter(StartRecommendationReportGenerationRequest::groupIdFilter)).setter(StartRecommendationReportGenerationRequest.setter(Builder::groupIdFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupIdFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Group::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputFormat").getter(StartRecommendationReportGenerationRequest.getter(StartRecommendationReportGenerationRequest::outputFormatAsString)).setter(StartRecommendationReportGenerationRequest.setter(Builder::outputFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputFormat").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_ID_FILTER_FIELD, OUTPUT_FORMAT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("groupIdFilter", GROUP_ID_FILTER_FIELD);
            this.put("outputFormat", OUTPUT_FORMAT_FIELD);
        }
    });
    private final List<Group> groupIdFilter;
    private final String outputFormat;

    private StartRecommendationReportGenerationRequest(BuilderImpl builder) {
        super(builder);
        this.groupIdFilter = builder.groupIdFilter;
        this.outputFormat = builder.outputFormat;
    }

    public final boolean hasGroupIdFilter() {
        return this.groupIdFilter != null && !(this.groupIdFilter instanceof SdkAutoConstructList);
    }

    public final List<Group> groupIdFilter() {
        return this.groupIdFilter;
    }

    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(this.outputFormat);
    }

    public final String outputFormatAsString() {
        return this.outputFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupIdFilter() ? this.groupIdFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.outputFormatAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRecommendationReportGenerationRequest)) {
            return false;
        }
        StartRecommendationReportGenerationRequest other = (StartRecommendationReportGenerationRequest)((Object)obj);
        return this.hasGroupIdFilter() == other.hasGroupIdFilter() && Objects.equals(this.groupIdFilter(), other.groupIdFilter()) && Objects.equals(this.outputFormatAsString(), other.outputFormatAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartRecommendationReportGenerationRequest").add("GroupIdFilter", this.hasGroupIdFilter() ? this.groupIdFilter() : null).add("OutputFormat", (Object)this.outputFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupIdFilter": {
                return Optional.ofNullable(clazz.cast(this.groupIdFilter()));
            }
            case "outputFormat": {
                return Optional.ofNullable(clazz.cast(this.outputFormatAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartRecommendationReportGenerationRequest, T> g) {
        return obj -> g.apply((StartRecommendationReportGenerationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyRequest.BuilderImpl
    implements Builder {
        private List<Group> groupIdFilter = DefaultSdkAutoConstructList.getInstance();
        private String outputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRecommendationReportGenerationRequest model) {
            super(model);
            this.groupIdFilter(model.groupIdFilter);
            this.outputFormat(model.outputFormat);
        }

        public final List<Group.Builder> getGroupIdFilter() {
            List<Group.Builder> result = GroupIdsCopier.copyToBuilder(this.groupIdFilter);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupIdFilter(Collection<Group.BuilderImpl> groupIdFilter) {
            this.groupIdFilter = GroupIdsCopier.copyFromBuilder(groupIdFilter);
        }

        @Override
        public final Builder groupIdFilter(Collection<Group> groupIdFilter) {
            this.groupIdFilter = GroupIdsCopier.copy(groupIdFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIdFilter(Group ... groupIdFilter) {
            this.groupIdFilter(Arrays.asList(groupIdFilter));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIdFilter(Consumer<Group.Builder> ... groupIdFilter) {
            this.groupIdFilter(Stream.of(groupIdFilter).map(c -> (Group)((Group.Builder)Group.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOutputFormat() {
            return this.outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRecommendationReportGenerationRequest build() {
            return new StartRecommendationReportGenerationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartRecommendationReportGenerationRequest> {
        public Builder groupIdFilter(Collection<Group> var1);

        public Builder groupIdFilter(Group ... var1);

        public Builder groupIdFilter(Consumer<Group.Builder> ... var1);

        public Builder outputFormat(String var1);

        public Builder outputFormat(OutputFormat var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

